package response

import (
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"
)

// 系统组织表
type SystemOrganizationTree struct {
	Id               int64                    `json:"id" xorm:"pk autoincr"`       //id
	OrganizationId   string                   `json:"organization_id"`             //组织id
	Name             string                   `json:"name"`                        //组织名称or目录名称
	POrganizationId  string                   `json:"p_organization_id"`           //父级组织id
	Description      string                   `json:"description"`                 //组织介绍
	OrganizationCode string                   `json:"organization_code"`           //组织机构代码
	Sort             int64                    `json:"sort"`                        //排序
	DataType         int64                    `json:"data_type"`                   //数据类型(0目录 1组织)
	CreatedTime      jsontime.Time            `json:"created_time" xorm:"created"` //创建时间
	UpdatedTime      jsontime.Time            `json:"updated_time" xorm:"updated"` //更新时间
	CreatedBy        string                   `json:"created_by"`                  //创建者
	UpdatedBy        string                   `json:"updated_by"`                  //更新者
	Level            int64                    `json:"level"`                       //组织节点层级
	Child            []SystemOrganizationTree `xorm:"-"`
}

// 组织管理员列表
type OrgAdminUser struct {
	Id            int           `json:"id" xorm:"pk autoincr" `               // id
	SystemAccount string        `json:"system_account" xorm:"system_account"` // 系统账号
	SystemRole    []string      `json:"system_role" xorm:"-"`                 // 系统角色
	CreatedTime   jsontime.Time `json:"created_time" xorm:"created" `         // 创建时间
	State         int           `json:"state" xorm:"state"`                   // 状态0禁用1启用
	Phone         string        `json:"phone" xorm:"phone"`                   // 手机号
}

// 账号详情
type OrgUserDetail struct {
	Id             int32         `json:"id" xorm:"pk autoincr" `               // id
	Name           string        `json:"name" xorm:"name"`                     // 联系人姓名
	Phone          string        `json:"phone" xorm:"phone"`                   // 联系人电话
	SystemAccount  string        `json:"system_account" xorm:"system_account"` // 系统账号
	SystemRole     []string      `json:"system_role" xorm:"-"`                 // 系统角色id
	Organization   string        `json:"organization" xorm:"organization"`     // 所属组织
	OrganizationId string        `json:"organization_id"`                      // 所属组织
	CreatedBy      int           `json:"created_by"`                           // 创建者
	CreatedName    string        `json:"created_name"`                         // 创建账号
	UpdatedTime    jsontime.Time `json:"updated_time" xorm:"updated" `         // 更新时间
	CreatedTime    jsontime.Time `json:"created_time" xorm:"created" `         // 创建时间
	Logo           string        `json:"logo"`                                 // 头像logo
	State          int           `json:"state"`                                // 状态0禁用1启用
}

// 编辑组织账号
type UpdateOrgUser struct {
	ContactPhone   string `json:"contact_phone" xorm:"contact_phone"`   // 联系人电话
	SystemAccount  string `json:"system_account" xorm:"system_account"` // 系统账号
	ContactName    string `json:"contact_name" xorm:"contact_name"`     // 联系人姓名
	ContactEmail   string `json:"contact_email" xorm:"contact_email"`   // 联系人邮箱
	DocumentType   int64  `json:"document_type"`                        // 证件类型
	DocumentNumber string `json:"document_number"`                      // 证件号
	Remark         string `json:"remark" xorm:"remark"`                 // 备注
	Logo           string `json:"logo"`                                 // 头像logo
	State          int    `json:"state"`                                // 状态0禁用1启用
}

// 机构详情
type OrgDetail struct {
	//OrganizationType string        `json:"organization_type"`           //机构类型
	OrganizationCode string        `json:"organization_code"`           //组织机构代码
	Name             string        `json:"name"`                        //机构名称
	CreatedTime      jsontime.Time `json:"created_time" xorm:"created"` //创建时间
	//OrgAdminNumber       int64         `json:"org_admin_number"`            //组织管理员数
	//BusinessSystemNumber int64         `json:"business_system_number"`      //业务系统数
	//Attachment           string        `json:"attachment"`                  //组织附件
	Description         string `json:"description"`           //组织介绍
	PlatformUsersNumber int64  `json:"platform_users_number"` //平台用户数
}
