package response

import (
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"
	"time"
)

// 系统用户角色关联查询
type SystemUserRole struct {
	UserId   int    `json:"user_id" xorm:"user_id"` // 用户id
	RoleId   string `json:"role_id" xorm:"role_id"` // 角色id
	RoleName string `json:"role_name"`              // 角色名称
}

type SystemRoleList struct {
	Id          int64     `json:"id"`           // id
	RoleName    string    `json:"role_name"`    // 角色名称
	RoleDesc    string    `json:"role_desc"`    // 角色描述
	State       int       `json:"state"`        // 状态0禁用1启用
	CreatedBy   string    `json:"created_by"`   // 角色创建人
	CreatedTime time.Time `json:"created_time"` // 角色创建时间
	RoleType    int       `json:"role_type"`    // 角色类型（0 普通角色 1 内置角色类型 不能删除和编辑 ）
	RoleId      string    `json:"role_id"`      // 角色id（uuid）
	//DataPurview   int       `json:"data_purview"`                         // 数据权限：1-仅自己，2-本组织所有，3-全平台所有
	UserCount     int    `json:"user_count"`                           // 用户数
	CantAllot     int    `json:"cant_allot"`                           // 是否可分配用户
	SystemAccount string `json:"system_account" xorm:"system_account"` // 系统账号
}

// SystemRoleDetailRes 系统角色详情
type SystemRoleDetailRes struct {
	Id       int64  `json:"id"`        // id
	RoleName string `json:"role_name"` // 角色名称
	RoleDesc string `json:"role_desc"` // 角色描述
	State    int    `json:"state"`     // 状态0禁用1启用
	//DataPurview int           `json:"data_purview"` // 数据权限：1-仅自己，2-本组织所有，3-全平台所有
	RoleId      string        `json:"role_id"`      // 角色id（uuid）
	CreatedTime jsontime.Time `json:"created_time"` // 角色创建时间
	UpdatedTime jsontime.Time `json:"updated_time"` // 角色更新时间
	RoleType    int           `json:"role_type"`    // 角色类型（0 普通角色 1 内置角色类型 不能删除和编辑 ）
	Menus       []SystemMenus `json:"menus"`        // 菜单
}
type SystemRoleListRes struct {
	Id          int64         `json:"id"`           // id
	RoleName    string        `json:"role_name"`    // 角色名称
	RoleDesc    string        `json:"role_desc"`    // 角色描述
	State       int           `json:"state"`        // 状态0禁用1启用
	CreatedBy   string        `json:"created_by"`   // 角色创建人
	CreatedTime jsontime.Time `json:"created_time"` // 角色创建时间
	RoleType    int           `json:"role_type"`    // 角色类型（0 普通角色 1 内置角色类型 不能删除和编辑 ）
	RoleId      string        `json:"role_id"`      // 角色id（uuid）
	//DataPurview int           `json:"data_purview"` // 数据权限：1-仅自己，2-本组织所有，3-全平台所有
	UserCount int `json:"user_count"` // 用户数
	CantAllot int `json:"cant_allot"` // 是否可分配用户

}
type SystemAllotUserList struct {
	Id               int32     `json:"id" `                              // id
	SystemAccount    string    `json:"system_account"`                   // 系统账号
	IsAdmin          int       `json:"is_admin"`                         // 用户类型
	Phone            string    `json:"phone"`                            // 联系人电话
	OrganizationId   string    `json:"organization_id"`                  // 所属组织
	OrganizationName string    `json:"organization_name" xorm:"name"`    // 所属组织
	State            int       `json:"state"`                            // 状态0禁用1启用
	CreatedTime      time.Time `json:"created_time"`                     // 创建时间
	SystemId         string    `json:"system_id" xorm:"system_id"`       // 系统账号id
	UrSystemId       string    `json:"ur_system_id" xorm:"ur_system_id"` // 系统账号id
	IsBind           int       `json:"is_bind"`                          // 是否绑定 0否1是
}

type SystemAllotUserListRes struct {
	Id               int32         `json:"id" `               // id
	SystemAccount    string        `json:"system_account"`    // 系统账号
	IsAdmin          int           `json:"is_admin"`          // 用户类型
	Phone            string        `json:"phone"`             // 联系人电话
	OrganizationId   string        `json:"organization_id"`   // 所属组织
	OrganizationName string        `json:"organization_name"` // 所属组织
	State            int           `json:"state"`             // 状态0禁用1启用
	CreatedTime      jsontime.Time `json:"created_time"`      // 创建时间
	SystemId         string        `json:"system_id"`         // 系统账号id
	IsBind           int           `json:"is_bind"`           // 是否绑定 0否1是
}
