package response

import (
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"
	"time"
)

type SystemUserList struct {
	Id               int32     `json:"id" `                                    // id
	OrganizationId   string    `json:"organization_id" xorm:"organization_id"` // 所属组织
	OrganizationName string    `json:"organization_name" xorm:"name"`          // 所属组织
	BusinessCode     string    `json:"business_code" xorm:"business_code"`     // 业务系统编码
	BusinessName     string    `json:"business_name" xorm:"business_name"`     // 业务系统名称
	SystemAccount    string    `json:"system_account" xorm:"system_account"`   // 系统账号
	State            int       `json:"state" xorm:"state"`                     // 状态0禁用1启用
	CreatedTime      time.Time `json:"created_time" xorm:"created" `           // 创建时间
	SystemId         string    `json:"system_id" xorm:"system_id"`             // 系统账号id
}

type SystemUserDetailRes struct {
	BusinessCode     string        `json:"business_code"`     // 业务系统编码
	BusinessName     string        `json:"business_name"`     // 业务系统名称
	OrganizationId   string        `json:"organization_id"`   // 所属组织
	OrganizationName string        `json:"organization_name"` // 所属组织名称
	SystemAccount    string        `json:"system_account"`    // 系统账号
	AppId            string        `json:"app_id"`            // appId
	AppSecret        string        `json:"app_secret"`        // appSecret
	CreatedBy        string        `json:"created_by"`        // 创建者
	CreatedTime      jsontime.Time `json:"created_time"`      // 创建时间
	State            int           `json:"state"`             // 状态0禁用1启用
	DevelopId        string        `json:"develop_id"`        // 开发厂商uuid
	DevelopName      string        `json:"develop_name"`      // 开发厂商名称
	AccessAddress    string        `json:"access_address"`    // 访问地址
	BusinessDesc     string        `json:"business_desc"`     // 业务系统描述
	Logo             string        `json:"logo"`              // 头像logo
	ContactName      string        `json:"contact_name"`      // 联系人姓名
	ContactPhone     string        `json:"contact_phone"`     // 联系人电话
	ContactEmail     string        `json:"contact_email"`     // 联系人邮箱
	Remark           string        `json:"remark"`            // 备注
	SystemId         string        `json:"system_id"`         // 系统账号id
	IsAdmin          int           `json:"is_admin"`          // 用户类型
	CreatedUserRole  []string      `json:"created_user_role"` // 系统角色
}

type SystemUserListRes struct {
	Id               int32         `json:"id" `               // id
	OrganizationId   string        `json:"organization_id"`   // 所属组织
	OrganizationName string        `json:"organization_name"` // 所属组织
	BusinessCode     string        `json:"business_code"`     // 业务系统编码
	BusinessName     string        `json:"business_name"`     // 业务系统名称
	SystemAccount    string        `json:"system_account"`    // 系统账号
	State            int           `json:"state"`             // 状态0禁用1启用
	CreatedTime      jsontime.Time `json:"created_time" `     // 创建时间
	SystemId         string        `json:"system_id"`         // 系统账号id
}
