/**
 * @Author: gaoshiyao
 * @Description: db
 * @File:  db
 * @Date: 2021/05/08 14:33
 */

package client

import (
	"time"

	_ "github.com/lib/pq"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"go.uber.org/zap"
	"xorm.io/xorm"
	"xorm.io/xorm/names"
)

var dbCli *xorm.Engine

func GetDbClient() (xormDB *xorm.Engine, err error) {
	if dbCli != nil {
		return dbCli, nil
	}
	xormDB, err = xorm.NewEngine(conf.Options.DbDriver, conf.Options.DbURL)
	if err != nil {
		conf.Logger.Error("创建xorm引擎", zap.Error(err), zap.String("dbURL", conf.Options.DbURL))
		return nil, err
	}
	if err = xormDB.Ping(); err != nil {
		conf.Logger.Error("ping db", zap.Error(err), zap.String("dbURL", conf.Options.DbURL))
		return nil, err
	}
	xormDB.SetMapper(names.SnakeMapper{})
	if conf.RunMode == "debug" {
		xormDB.ShowSQL(true)
	}
	xormDB.TZLocation, _ = time.LoadLocation("Asia/Shanghai")
	xormDB.SetMaxOpenConns(50)                      // 数据库连接数
	xormDB.SetMaxIdleConns(10)                      // 空闲数
	xormDB.DB().SetConnMaxIdleTime(5 * time.Minute) // 最大闲置时间
	dbCli = xormDB
	conf.Logger.Info("connect db", zap.String("dbURL", conf.Options.DbURL))
	return dbCli, err
}
