package client

import (
	"fmt"
	"github.com/minio/minio-go/v7"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"net/url"

	"github.com/minio/minio-go/v7/pkg/credentials"
)

var MinioClient *minio.Client

func GetMinioConnect() (*minio.Client, error) {
	if MinioClient != nil {
		return MinioClient, nil
	}
	parse, err := url.Parse(conf.Options.MinioServer)
	if err != nil {
		return MinioClient, err
	}
	minioClient, err := minio.New(parse.Host, &minio.Options{
		Creds:  credentials.NewStaticV4(conf.Options.MinioAccessKey, conf.Options.MinioSecretKey, ""),
		Secure: false,
	})
	if err != nil {
		return MinioClient, err
	}
	MinioClient = minioClient
	fmt.Printf("connect Minio Server { %s } success!\n", conf.Options.MinioServer)
	return MinioClient, err
}
