package controller

import (
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
)

func PrometheusLabel(c *gin.Context) {
	var req request.PrometheusLabel
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.TranslateError(err), nil)
		return
	}

	svc := service.PrometheusSvc{User: header.GetUser(c)}
	data, err := svc.Label(req)
	if err != nil {
		SendJsonResponse(c, resp.FAIL.WithError(err), nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}
