package controller

import (
	"errors"
	vd "github.com/bytedance/go-tagexpr/validator"
	"github.com/gin-gonic/gin"
	"github.com/spf13/cast"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
)

func AddSystemMenu(c *gin.Context) {
	input := request.SystemMenuReq{}
	if err := c.ShouldBindJSON(&input); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), nil)
		return
	}
	if input.PMenuId != "" && input.MenuType == 0 && input.DictGroupId == "" {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(errors.New("请选择分组")), nil)
		return
	}
	if input.PMenuId != "" && input.MenuUrl == "" {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(errors.New("请填写菜单路径")), nil)
		return
	}
	sm := service.SystemMenu{User: header.GetUser(c)}
	data, err := sm.AddSystemMenu(input)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}

func DeleteMenu(c *gin.Context) {
	sm := service.SystemMenu{}
	if err := sm.DeleteMenu(cast.ToInt64(c.Param("id"))); err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func MenuSort(c *gin.Context) {
	var input []request.MenuSortInput
	if err := c.ShouldBindJSON(&input); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), nil)
		return
	}
	sm := service.SystemMenu{User: header.GetUser(c)}
	if err := sm.SortMenu(input); err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// 更新菜单
func UpdateMenu(c *gin.Context) {
	var input request.SystemMenuReq
	if err := c.ShouldBindJSON(&input); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), nil)
		return
	}
	//参数检测
	if err := vd.Validate(input); err != nil {
		SendJsonResponse(c, resp.InvalidParam.ErrorDetail(err), "")
		return
	}
	sm := service.SystemMenu{User: header.GetUser(c)}
	if err := sm.UpdateMenu(cast.ToInt64(c.Param("id")), input); err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

func GetMenuTree(c *gin.Context) {
	sm := service.SystemMenu{}
	result, err := sm.GetMenuTree()
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, result)
}

func GetGroupDict(c *gin.Context) {
	sm := service.SystemMenu{}
	result, err := sm.GetGroupDict()
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, result)
}

func GetSystemTree(c *gin.Context) {
	search := c.Query("search")
	sm := service.SystemMenu{User: header.GetUser(c)}
	result, err := sm.GetSystemTree(search)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, result)
}
