package controller

import (
	"errors"
	"github.com/gin-gonic/gin"
	"github.com/spf13/cast"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/util"
)

// AddTaskManage 新增任务
func AddTaskManage(c *gin.Context) {
	var req request.AddTaskManageReq
	if err := c.ShouldBindJSON(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}
	//参数校验
	if err := util.ValidateSimple(req, "TaskName,HostGroupId"); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	taskManageSvc := service.TaskManageSvc{}
	err := taskManageSvc.AddTaskManage(req)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// EditTaskManage 编辑任务
func EditTaskManage(c *gin.Context) {
	var req request.EditTaskManageReq
	if err := c.ShouldBindJSON(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}
	//参数校验
	if err := util.ValidateSimple(req, "Id,HostGroupId"); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	taskManageSvc := service.TaskManageSvc{}
	err := taskManageSvc.EditTaskManage(req)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// DelTaskManage 删除任务
func DelTaskManage(c *gin.Context) {
	var req request.DelTaskManageReq
	if err := c.ShouldBindJSON(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}
	//参数校验
	if err := util.ValidateSimple(req, "Id"); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	taskManageSvc := service.TaskManageSvc{}
	err := taskManageSvc.DelTaskManage(req)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, nil)
}

// DetailsTaskManage 任务详情
func DetailsTaskManage(c *gin.Context) {
	var (
		err error
		id  string
	)

	if id = c.Query("id"); id == "" {
		id = c.Param("id")
	}
	if id == "" {
		SendJsonResponse(c, resp.InvalidParam.WithError(errors.New("id为空")), nil)
		return
	}

	taskManageSvc := service.TaskManageSvc{}
	data, err := taskManageSvc.DetailsTaskManage(cast.ToInt(id))
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, resp.OK, data)
}

// ListTaskManage 任务列表
func ListTaskManage(c *gin.Context) {
	var req request.ListTaskManageReq
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}

	taskManageSvc := service.TaskManageSvc{}
	total, list, err := taskManageSvc.ListTaskManage(req)
	if err != nil {
		SendJsonPageResponse(c, err, nil, 0)
		return
	}
	SendJsonPageResponse(c, resp.OK, list, total)
}

func ExecScript(c *gin.Context) {
	var req request.ExecScriptReq
	if err := c.ShouldBind(&req); err != nil {
		SendJsonResponse(c, resp.InvalidParam.WithError(err), nil)
		return
	}
	taskManageSvc := service.TaskManageSvc{}
	data, err := taskManageSvc.ExecScript(req)
	if err != nil {
		SendJsonResponse(c, err, nil)
		return
	}
	SendJsonResponse(c, nil, data)
}
