package router

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
)

// InitSystemLoginRouter 初始化登录相关路由
func InitSystemLoginRouter(e *gin.Engine) {
	base := e.Group(fmt.Sprintf("%s/user", conf.Options.Prefix))
	{
		base.POST("/login", controller.UserLogin)            // 登录
		base.POST("/logout", controller.UserLogout)          // 登出
		base.GET("/getUserInfo", controller.GetUserInfo)     // 获取用户信息
		base.GET("/getCaptcha", controller.GetCaptcha)       // 获取验证码
		base.GET("/verifyCaptcha", controller.VerifyCaptcha) // 校验验证码
	}
}
