package header

import (
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/entity"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/service"
)

func SetContext(c *gin.Context) {
	bgToken, _ := c.Cookie(conf.CookieName)
	if bgToken == "" {
		c.String(401, "用户未登录!")
		c.Abort()
		return
	}

	svc := service.UserSvc{}
	m, err := svc.GetCurUser(bgToken)
	if err != nil {
		c.String(500, "用户未登录!")
		c.Abort()
		return

	}

	c.Set("user_info", m)
	c.Next()
}

func GetUser(c *gin.Context) entity.SystemUserInfo {
	val, ok := c.Get("user_info")
	if !ok {
		return entity.SystemUserInfo{}
	}

	user, ok := val.(entity.SystemUserInfo)
	if !ok {
		return entity.SystemUserInfo{}
	}
	return user
}
