package router

import (
	"fmt"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"

	"github.com/gin-gonic/gin"
)

// InitSystemRoleRouter 初始化角色相关路由
func InitSystemRoleRouter(e *gin.Engine) {
	base := e.Group(fmt.Sprintf("%s/role", conf.Options.Prefix), header.SetContext)

	{
		base.PUT("create", controller.CreateSystemRole)                 // 添加系统角色
		base.POST("update", controller.UpdateSystemRole)                // 编辑系统角色
		base.POST("state/:id/:state", controller.SystemRoleState)       // 系统角色状态
		base.GET("list", controller.SystemRoleList)                     // 系统角色列表
		base.GET("detail/:id", controller.SystemRoleDetail)             // 系统角色详情
		base.POST("allotment/user", controller.SystemRoleAllotmentUser) // 角色分配账户
		base.GET("allotment/list", controller.SystemAllotUserList)      // 角色可分配账户列表
		base.DELETE("delete", controller.DeleteSystemRole)              // 删除系统角色
	}
}
