package router

import (
	"fmt"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/conf"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/controller"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/router/middleware/header"

	"github.com/gin-gonic/gin"
)

// 初始化登录相关路由
func InitSystemUserRouter(e *gin.Engine) {
	base := e.Group(fmt.Sprintf("%s/user", conf.Options.Prefix), header.SetContext)

	{

		base.GET("/:id", controller.OrgUserDetail)        //查询组织用户详情
		base.GET("/select/role", controller.OrgUserRoles) //注册平台用户使用的查询角色列表
		base.POST("/add", controller.OrgAddUser)          //添加组织用户
		base.PUT("/:id", controller.OrgUpdateUser)        //组织编辑用户
		base.DELETE("/del", controller.DelOrgUser)        //删除组织用户
		base.POST("/check", controller.CheckRepetition)   //去重校验

		base.POST("/updatePwd", controller.SystemUserEditPassword) // 修改账户密码
		base.POST("/resetPwd", controller.ResetSystemUserPassword) // 重置账户密码

	}
}
