package service

import (
	"github.com/google/uuid"
	"github.com/jinzhu/copier"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/entity"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/response"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/client"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/jsontime"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/util"
)

type MetricConfigSvc struct {
	User entity.SystemUserInfo
}

func (m *MetricConfigSvc) Add(req request.AddMetricConfig) error {
	db, err := client.GetDbClient()
	if err != nil {
		err = resp.DbConnectError.WithError(err)
		return err
	}
	now := jsontime.Now()
	mc := entity.MetricConfig{
		Id:        uuid.New().String(),
		CreatedBy: "",
		CreatedAt: now,
		UpdatedBy: "",
		UpdatedAt: now,
	}
	_ = copier.Copy(&mc, &req)
	mc.AlertRange = util.ConvertToString(req.AlertRange)

	_, err = db.NewSession().Insert(&mc)
	if err != nil {
		return err
	}
	return nil
}

func (m *MetricConfigSvc) Update(req request.UpdateMetricConfig) error {
	db, err := client.GetDbClient()
	if err != nil {
		err = resp.DbConnectError.WithError(err)
		return err
	}
	now := jsontime.Now()
	mc := entity.MetricConfig{
		UpdatedBy: "",
		UpdatedAt: now,
	}
	_ = copier.Copy(&mc, &req)
	mc.AlertRange = util.ConvertToString(req.AlertRange)

	_, err = db.NewSession().ID(req.Id).Update(&mc)
	if err != nil {
		return err
	}
	return nil
}

func (m *MetricConfigSvc) GetDataById(req request.DetailMetricConfig) (resp response.MetricConfigItem, err error) {
	db, err := client.GetDbClient()
	if err != nil {
		return
	}
	_, err = db.NewSession().Table(resp.TableName()).Where("id = ?", req.Id).Get(&resp)
	return
}

func (m *MetricConfigSvc) List(req request.ListMetricConfig) (resp response.UnitsList, err error) {
	db, err := client.GetDbClient()
	if err != nil {
		return
	}
	session := db.NewSession()
	defer session.Close()
	if req.Id != "" {
		session.Where("id = ?", req.Id)
	}
	if req.ClassId != 0 {
		session.Where("class_id = ?", req.ClassId)
	}
	if req.MetricName != "" {
		session.Where("metric_name LIKE ?", "%"+req.MetricName+"%")
	}
	if req.IsEnabled != 0 {
		session.Where("is_enabled = ?", req.IsEnabled)
	}
	resp.TotalCount, err = session.Limit(req.GetPageSize(), (req.GetPage()-1)*req.GetPageSize()).
		OrderBy("id").FindAndCount(&resp.List)
	return
}

func (m *MetricConfigSvc) Delete(ids []string) (err error) {
	db, err := client.GetDbClient()
	if err != nil {
		return
	}
	_, err = db.NewSession().In("id", ids).Delete(new(entity.MetricConfig))
	return
}
