package service

import (
	"github.com/pkg/errors"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/entity"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/request"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/bean/vo/response"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/common/client"
	"gitlab.wodcloud.com/smart-operation/so-operation-api/src/pkg/beagle/resp"
	"time"
)

type TaskHistorySvc struct {
	User *entity.SystemUser
}

// TaskHistoryList 任务历史列表
func (t *TaskHistorySvc) TaskHistoryList(req request.Pagination) (total int64, taskHistoryListRes []response.TaskHistoryListRes, err error) {
	var (
		//dueDate int
		start time.Time
		end   time.Time
	)
	db, err := client.GetDbClient()
	if err != nil {
		err = resp.DbConnectError.WithError(err)
		return
	}

	finder := db.Table("task_manage").Alias("t1").
		Join("RIGHT", "(SELECT task_id,exec_start_time,exec_end_time,create_user,state FROM task_history"+
			" WHERE ID IN (SELECT MAX(ID) FROM task_history GROUP BY task_id) ORDER BY ID DESC) t2", "t1.id = t2.task_id").
		Where("t1.is_delete = 0")

	//查询任务历史
	total, err = finder.Select("t2.state,t2.task_id,t1.task_name,t2.exec_start_time,t2.exec_end_time,t2.create_user").
		Limit(req.PageSize, (req.Page-1)*req.PageSize).FindAndCount(&taskHistoryListRes)
	if err != nil {
		err = resp.DbSelectError.WithError(err)
		return
	}
	for k, v := range taskHistoryListRes {

		//获取执行耗时
		start, err = time.Parse("2006-01-02 15:04:05", v.ExecStartTime.Format("2006-01-02 15:04:05"))
		if err != nil {
			err = resp.FAIL.WithError(errors.Wrap(err, "时间转换错误！"))
			return
		}
		end, err = time.Parse("2006-01-02 15:04:05", v.ExecEndTime.Format("2006-01-02 15:04:05"))
		if err != nil {
			err = resp.FAIL.WithError(errors.Wrap(err, "时间转换错误！"))
			return
		}
		execTime := int(end.Sub(start).Seconds())
		if execTime > 0 {
			taskHistoryListRes[k].ExecTime = execTime
		}
	}
	return
}

// TaskInfoList 任务历史详情列表
func (t *TaskHistorySvc) TaskInfoList(req request.TaskHistoryReq) (total int64, taskInfoListRes []response.TaskInfoListRes, err error) {
	var (
		//dueDate int
		start time.Time
		end   time.Time
	)
	db, err := client.GetDbClient()
	if err != nil {
		err = resp.DbConnectError.WithError(err)
		return
	}

	finder := db.Table("task_history").Where("task_id = ?", req.TaskId)

	//查询任务历史
	total, err = finder.OrderBy("id desc").Limit(req.PageSize, (req.Page-1)*req.PageSize).FindAndCount(&taskInfoListRes)
	if err != nil {
		err = resp.DbSelectError.WithError(err)
		return
	}

	for k, v := range taskInfoListRes {
		//获取执行耗时
		start, err = time.Parse("2006-01-02 15:04:05", v.ExecStartTime.Format("2006-01-02 15:04:05"))
		if err != nil {
			err = resp.FAIL.WithError(errors.Wrap(err, "时间转换错误！"))
			return
		}
		end, err = time.Parse("2006-01-02 15:04:05", v.ExecEndTime.Format("2006-01-02 15:04:05"))
		if err != nil {
			err = resp.FAIL.WithError(errors.Wrap(err, "时间转换错误！"))
			return
		}
		execTime := int(end.Sub(start).Seconds())
		if execTime > 0 {
			taskInfoListRes[k].ExecTime = execTime
		}
	}
	return
}

// TaskExecLog 任务执行日志
func (t *TaskHistorySvc) TaskExecLog(id int) (taskExecLogRes response.TaskExecLogRes, err error) {
	var (
		//dueDate int
		start time.Time
		end   time.Time
	)
	db, err := client.GetDbClient()
	if err != nil {
		err = resp.DbConnectError.WithError(err)
		return
	}

	//查询
	_, err = db.Table("task_history").Where("id = ?", id).Get(&taskExecLogRes)
	if err != nil {
		err = resp.DbSelectError.WithError(err)
		return
	}

	//获取执行耗时
	start, err = time.Parse("2006-01-02 15:04:05", taskExecLogRes.ExecStartTime.Format("2006-01-02 15:04:05"))
	if err != nil {
		err = resp.FAIL.WithError(errors.Wrap(err, "时间转换错误！"))
		return
	}
	end, err = time.Parse("2006-01-02 15:04:05", taskExecLogRes.ExecEndTime.Format("2006-01-02 15:04:05"))
	if err != nil {
		err = resp.FAIL.WithError(errors.Wrap(err, "时间转换错误！"))
		return
	}
	execTime := int(end.Sub(start).Seconds())
	if execTime > 0 {
		taskExecLogRes.ExecTime = execTime
	}

	return
}
