package util

import (
	"fmt"
	"github.com/gin-gonic/gin/binding"
	"github.com/go-playground/locales/zh"
	ut "github.com/go-playground/universal-translator"
	"github.com/go-playground/validator/v10"
	translations "github.com/go-playground/validator/v10/translations/zh"
	"reflect"
)

var (
	validate *validator.Validate
	Trans    ut.Translator
)

func RegValid() {
	// 注册自定义的校验器错误消息
	Trans, _ = ut.New(zh.New()).GetTranslator("zh")
	validate = binding.Validator.Engine().(*validator.Validate)
	if err := translations.RegisterDefaultTranslations(validate, Trans); err != nil {
		fmt.Println("RegisterDefaultTranslations failed", err)
		return
	}

	validate.RegisterTagNameFunc(func(fld reflect.StructField) string {
		if jsonTag := fld.Tag.Get("json"); jsonTag != "" {
			return jsonTag
		}
		if formTag := fld.Tag.Get("form"); formTag != "" {
			return formTag
		}
		return fld.Name
	})

	//validate.RegisterValidation("required_if", requiredIf)
}
