package com.pms.ocp.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.pms.ocp.model.dto.OcpTenantBaseDto;
import com.pms.ocp.model.entity.OcpTenantBase;
import com.pms.ocp.model.vo.ResponseVO;

import java.sql.Timestamp;
import java.util.List;

public interface TenantBasicManagementService extends IService<OcpTenantBase> {
    /**
     * 条件查询
     * @param tenantCode
     * @param keyword
     * @param tenantUnit
     * @param startTime
     * @param endTime
     * @param pageSize
     * @param pageNum
     * @return
     */
    List<OcpTenantBaseDto> queryOcpTenantBaseDto(String tenantCode, String keyword, String tenantUnit, Timestamp startTime, Timestamp endTime, int pageSize, int pageNum);

    /**
     * 应用发布 改变其应用状态
     * @param tenantCodes 应用代码
     * @return
     */
    ResponseVO tenantIssue(String tenantCodes);

    /**
     * 应用订阅
     * @param tenantCodes
     */
    void tenantLogin(String tenantCodes);

    /**
     * 应用下线
     * @param tenantCodes
     */
    ResponseVO tenantCancel(String tenantCodes);

    /**
     * 应用注册
     * @param ocpTenantBaseDto
     */
    ResponseVO applyRegister(OcpTenantBaseDto ocpTenantBaseDto);
}
