package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.pms.ocp.common.utils.ExcelUtils;
import com.pms.ocp.mapper.ModelNoteMapper;
import com.pms.ocp.model.entity.ModelNote;
import com.pms.ocp.service.ModelNoteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:21
 * @Description:模型事记业务层实现
 */

@Service
public class ModelNoteServiceImpl implements ModelNoteService {

    @Autowired
    private ModelNoteMapper modelNoteMapper;

    @Override
    public Integer createModelNote(ModelNote modelNote) {
        return modelNoteMapper.insert(modelNote);
    }

    @Override
    public Integer deleteModelNote(String modelId) {
        return null;
    }

    @Override
    public Integer updateModelNote(ModelNote modelNote) {
        return null;
    }

    @Override
    public List<ModelNote> getModelNoteList(String modelCode) {

        QueryWrapper<ModelNote> wrapper = new QueryWrapper<>();
        wrapper.lambda().eq(ModelNote::getModelCode, modelCode);
        return modelNoteMapper.selectList(wrapper);
    }

    @Override
    public ModelNote getModelNote(String modelId) {
        return null;
    }

//    @Override
//    public Boolean exportModelNote(String modelCode) {
//        List<ModelNote> modelNoteList = getModelNoteList(modelCode);
//
//        ExcelUtils.exportExcel(modelNoteList, "导出事记", "导出事记", ModelNote.class, "测试user.xls", re
//
//        return true;
//    }
}
