package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.mapper.OcpTenantExtentMapper;
import com.pms.ocp.mapper.TenantBasicManagementMapper;
import com.pms.ocp.model.dto.OcpApiBaseDto;
import com.pms.ocp.model.dto.OcpTenantBaseDto;
import com.pms.ocp.model.entity.*;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.*;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.StringUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

@Service
public class TenantBasicManagementServiceImpl extends ServiceImpl<TenantBasicManagementMapper, OcpTenantBase> implements TenantBasicManagementService {
    @Autowired
    private TenantBasicManagementMapper tenantBasicManagementMapper;
    @Autowired
    private OcpTenantExtentMapper ocpTenantExtentMapper;
    @Autowired
    private OcpTenantSubsService ocpTenantSubsService;
    @Autowired
    private OcpApiTenantRelService ocpApiTenantRelService;
    @Autowired
    private OcpTenantGroupService ocpTenantGroupService;

    /**
     * 条件查询
     *
     * @param tenantCode
     * @param keyword
     * @param tenantUnit
     * @param startTime
     * @param endTime
     * @param pageSize
     * @param pageNum
     * @return
     */
    @Override
    public List<OcpTenantBaseDto> queryOcpTenantBaseDto(String tenantCode, String keyword, String tenantUnit, Timestamp startTime, Timestamp endTime, int pageSize, int pageNum) {
        pageSize = (pageSize - 1) * pageNum;
        return tenantBasicManagementMapper.queryOcpTenantBaseDto(keyword, tenantUnit, startTime, endTime, tenantCode, pageSize, pageNum);
    }

    /**
     * 应用发布  改变其应用状态
     *
     * @param tenantCodes 应用代码
     * @return
     */
    @Override
    public ResponseVO tenantIssue(String tenantCodes) {
        String[] split = tenantCodes.split(",");
        List<String> list = Arrays.asList(split);
        LambdaQueryWrapper<OcpTenantExtent> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(OcpTenantExtent::getTenantCode, list);
        List<OcpTenantExtent> ocpTenantExtents = ocpTenantExtentMapper.selectList(lambdaQueryWrapper);
        for (OcpTenantExtent ocpTenantExtent : ocpTenantExtents) {
            if (ocpTenantExtent.getTenantState() == 1) {
                return ResponseVO.error("已发布");
            } else {
                ocpTenantExtent.setTenantState((short) 1);
                ocpTenantExtentMapper.updateById(ocpTenantExtent);
            }
        }
        return ResponseVO.ok();
    }

    /**
     * 应用订阅
     *
     * @param tenantCodes
     */
    @Override
    public void tenantLogin(String tenantCodes) {
        String[] split = tenantCodes.split(",");
        List<String> tenantCode = Arrays.asList(split);
        for (String s : tenantCode) {
            OcpTenantSubs ocpTenantSubs = new OcpTenantSubs();
            ocpTenantSubs.setTenantCode(s);
            ocpTenantSubs.setSubsCompanyCode(null);
            ocpTenantSubs.setSubsLogTenantAtime(Timestamp.valueOf(LocalDateTime.now()));
            ocpTenantSubs.setSubsLogTenantCtime(Timestamp.valueOf(LocalDateTime.now()));
            ocpTenantSubs.setSubsLogTenantMtime(Timestamp.valueOf(LocalDateTime.now()));
            ocpTenantSubsService.save(ocpTenantSubs);
        }
    }

    /**
     * 应用下线
     *
     * @param tenantCodes
     */
    @Override
    public ResponseVO tenantCancel(String tenantCodes) {
        String[] split = tenantCodes.split(",");
        List<String> list = Arrays.asList(split);
        LambdaQueryWrapper<OcpTenantExtent> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(OcpTenantExtent::getTenantCode, list);
        List<OcpTenantExtent> ocpTenantExtents = ocpTenantExtentMapper.selectList(lambdaQueryWrapper);
        for (OcpTenantExtent ocpTenantExtent : ocpTenantExtents) {
            if (ocpTenantExtent.getTenantState() == 2) {
                return ResponseVO.error("已下线");
            } else {
                ocpTenantExtent.setTenantState((short) 2);
                ocpTenantExtentMapper.updateById(ocpTenantExtent);
            }
        }
        return ResponseVO.ok();
    }

    /**
     * 应用注册
     *
     * @param ocpTenantBaseDto
     */
    @Override
    public ResponseVO applyRegister(OcpTenantBaseDto ocpTenantBaseDto) {
        //OcpTenantBase
        String tenantGroupName = ocpTenantBaseDto.getTenantGroupName();//应用分类名称
        LambdaQueryWrapper<OcpTenantGroup> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(OcpTenantGroup::getTenantGroupName, tenantGroupName);
        OcpTenantGroup one = ocpTenantGroupService.getOne(lambdaQueryWrapper);
        if (one == null) {
            return ResponseVO.error("该应用分类不存在");
        }
        //获取应用分类编码
        String tenantGroupCode = one.getTenantGroupCode();

        OcpTenantBase ocpTenantBase = new OcpTenantBase();
        BeanUtils.copyProperties(ocpTenantBaseDto, ocpTenantBase);
        ocpTenantBase.setTenantGroupCode(tenantGroupCode);
        //OcpTenantBase
        tenantBasicManagementMapper.insert(ocpTenantBase);

        //ocp_tenant_extent
        OcpTenantExtent ocpTenantExtent = new OcpTenantExtent();
        BeanUtils.copyProperties(ocpTenantBaseDto, ocpTenantExtent);
        ocpTenantExtent.setDepCompanyCode(null);
        ocpTenantExtentMapper.insert(ocpTenantExtent);

        //ocp_api_tenant_rel
        String apiCodes = ocpTenantBaseDto.getApiCodes();
        if (StringUtils.isEmpty(apiCodes)) {
            return ResponseVO.error("服务编码为空");
        } else {
            OcpApiTenantRel ocpApiTenantRel = new OcpApiTenantRel();
            String[] split = apiCodes.split(",");
            List<String> apiCode = Arrays.asList(split);
            String tenantCode = ocpTenantBaseDto.getTenantCode();
            for (String s : apiCode) {
                ocpApiTenantRel.setApiCode(s);
                ocpApiTenantRel.setTenantDepCompanyCode(null);
                ocpApiTenantRel.setApiDepCompanyCode(null);
                ocpApiTenantRel.setTenantCode(tenantCode);
                ocpApiTenantRel.setApiTenantRelCtime(Timestamp.valueOf(LocalDateTime.now()));
                ocpApiTenantRel.setApiTenantRelMtime(Timestamp.valueOf(LocalDateTime.now()));
                //保存到数据库
                ocpApiTenantRelService.save(ocpApiTenantRel);
            }
        }
        return ResponseVO.ok();
    }

}
