package com.pms.ocp.controller;

import com.pms.ocp.common.constants.CodeEnum;
import com.pms.ocp.model.entity.Model;
import com.pms.ocp.model.entity.ModelType;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.ModelGroupService;
import com.pms.ocp.service.ModelPropertyService;
import com.pms.ocp.service.ModelService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

import static com.pms.ocp.common.constants.CodeEnum.REQUIRED_PARAMETER_EMPTY;
import static com.pms.ocp.common.constants.CodeEnum.SUCCESS;

/**
 * @Auther: wangjian
 * @Date: 2022/2/21 16:17
 * @Description:模型库管理接口
 */

@Slf4j
@RequestMapping("/model-base/v1")
@RestController
@Api(tags = "模型库管理接口")
public class ModelBaseController {

    @Autowired
    private ModelService modelService;

    @Autowired
    private ModelGroupService modelGroupService;

    @Autowired
    private ModelPropertyService modelPropertyService;

    /**
     * 模型分类-查询
     *
     * @return
     */
    @ApiOperation("模型分类-查询")
    @GetMapping("/get/model/type")
    public ResponseVO getModelType() {
        return modelGroupService.getModelType();
    }

    /**
     * 模型分类-增加
     *
     * @return
     */
    @ApiOperation("模型分类-增加")
    @PostMapping("/create/model/type")
    public ResponseVO createModelType(ModelType modelType) {
        return modelGroupService.createModelType(modelType);
    }

    /**
     * 模型分类-删除
     *
     * @return
     */
    @ApiOperation("模型分类-删除")
    @PostMapping("/delete/model/type")
    public ResponseVO deleteModelType(ModelType modelType) {
        String modelTypeId = modelType.getObjId();
        if (StringUtils.isNotBlank(modelTypeId)) {
            return modelGroupService.deleteModelType(modelTypeId);
        } else {
            return ResponseVO.error(CodeEnum.REQUIRED_PARAMETER_EMPTY);
        }
    }

    /**
     * 模型分类-修改
     *
     * @return
     */
    @ApiOperation("模型分类-修改")
    @PostMapping("/update/model/type")
    public ResponseVO updateModelType(ModelType modelType) {
        return modelGroupService.updateModelType(modelType);
    }

    /**
     * 模型-查询
     *
     * @return
     */
    @ApiOperation("模型-查询")
    @GetMapping("/get/model")
    public ResponseVO getModel() {
        return modelService.getModelList();
    }

    /**
     * 模型-增加
     *
     * @return
     */
    @ApiOperation("模型-增加")
    @PostMapping("/create/model")
    public ResponseVO createModel(@RequestBody Model model) {
        return modelService.createModel(model);
    }

    /**
     * 模型-删除
     *
     * @return
     */
    @ApiOperation("模型-删除")
    @PostMapping("/delete/model")
    public ResponseVO deleteModel(@RequestBody Model model) {
        String modelId = model.getObjId();
        if (StringUtils.isNotBlank(modelId)) {
            return modelService.deleteModel(modelId);
        } else {
            return ResponseVO.error(REQUIRED_PARAMETER_EMPTY);
        }
    }

    /**
     * 模型-修改
     *
     * @return
     */
    @ApiOperation("模型-修改")
    @PostMapping("/update/model")
    public ResponseVO updateModel(@RequestBody Model model) {
        return modelService.updateModel(model);
    }

    /**
     * 模型-下发/批量下发
     * TODO
     *
     * @return
     */
    @ApiOperation("模型-下发|批量下发")
    @PostMapping("/issue/model")
    public ResponseVO issueModel() {
        return ResponseVO.ok();
    }

    /**
     * 模型注册-上传
     *
     * @return
     */
    @ApiOperation("模型注册-上传")
    @PostMapping("/register/model")
    public ResponseVO registerModel() {
        return ResponseVO.ok();
    }

    /**
     * 模型订阅-增加
     *
     * @return
     */
    @ApiOperation("模型订阅-增加")
    @PostMapping("/create/model/subscribe")
    public ResponseVO createModelSubscribe() {
        return ResponseVO.ok();
    }

    /**
     * 模型订阅-查询
     *
     * @return
     */
    @ApiOperation("模型订阅-查询")
    @GetMapping("/get/model/subscribe")
    public ResponseVO getModelSubscribe() {
        return ResponseVO.ok();
    }

    /**
     * 模型事记-查询
     *
     * @return
     */
    @ApiOperation("模型事记-查询")
    @GetMapping("/get/model/note")
    public ResponseVO getModelNote() {
        return ResponseVO.ok();
    }

    /**
     * 模型事记-增加
     *
     * @return
     */
    @ApiOperation("模型事记-增加")
    @PostMapping("create/model/note")
    public ResponseVO createModelNote() {
        return ResponseVO.ok();
    }

    /**
     * 模型属性-增加
     *
     * @return
     */
    @ApiOperation("模型属性-增加")
    @PostMapping("create/model/property")
    public ResponseVO createModelProperty() {
        return ResponseVO.ok();
    }

    /**
     * 模型属性-查询
     *
     * @return
     */
    @ApiOperation("模型属性-查询")
    @GetMapping("get/model/property")
    public ResponseVO getModelProperty() {
        return ResponseVO.ok(modelPropertyService.getModelProperty());
    }

    /**
     * 模型属性-修改
     *
     * @return
     */
    @ApiOperation("模型属性-修改")
    @PostMapping("/update/model/property")
    public ResponseVO updateModelProperty() {
        return ResponseVO.ok();
    }

    /**
     * 模型属性-删除
     *
     * @return
     */
    @ApiOperation("模型属性-删除")
    @PostMapping("/delete/model/property")
    public ResponseVO deleteModelProperty() {
        return ResponseVO.ok();
    }

    /**
     * 模型拓扑关系-查询
     *
     * @return
     */
    @ApiOperation("模型拓扑关系-查询")
    @GetMapping("/get/model/topology")
    public ResponseVO getModelTopology() {
        return ResponseVO.ok();
    }

}
