package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:26
 * @Description:模型对象
 */

@Data
@Accessors(chain = true)
@TableName("ocp_model_base")
public class Model {

    /**
     * 模型编号
     */
    @TableId
    private String objId;

    /**
     * 模型名称
     */
    private String modelName;

    /**
     * 模型编码
     */
    private String modelCode;

    /**
     * 设备类型
     */
    private String equipType;

    /**
     * 所属专业
     */
    private String professionalKind;

    /**
     * 模型分类编码
     */
    private String modelGroupCode;

    /**
     * 模型表
     */
    private String modelTable;

    /**
     * 是否启用
     */
    private String isUse;


    /**
     * 模型推广类型
     * 0:统推,1：自建
     */
    private String modelPromotion;


    /**
     * 公司code
     */
    private String ownerCompanyCode;

    /**
     * 公司名称
     */
    private String ownerCompanyName;

    /**
     * 排列顺序
     */
    private String modelOrderNo;

    /**
     * 提交人id
     */
    private String modelUserId;


    /**
     * 提交人姓名
     */
    private String modelUserName;

    /**
     * 模型创建时间
     */
    @TableField(value = "model_ctime")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date modelCreateTime;

    /**
     * 模型修改时间
     */
    @TableField(value = "model_mtime")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date modelUpdateTime;
}

//      字段名称	    字段描述	    字段类型	允许为NULL	备注
//        model_id	主键	varchar(40)	否
//        model_name	模型名称	varchar(50)	否
//        model_code	模型编码	varchar(42)	否
//        equip_type	设备类型	varchar(42)	是
//        domain_type	所属专业	int4	是	0:输电,1:变电,2:配电,3:直流,4:计划,5:技术
//        model_group_id	模型分类id	varchar(42)	否
//        model_group_name	模型分类名称	varchar(50)	否
//        model_table	模型表	varchar(50)	否
//        model_relation	模型关联关系	text	是	存储模型之间的关系json格式；例如[{ model_group_id : t_public_manage_model_group.group_id}]
//        Is_use	是否启用	int4	否	0:不启用,1：启用
//        model_promotion	推广类型	int4	否	0:统推,1：自建
//        company_id	省公司ID	varchar(42)	是
//        company_name	省公司名称	varchar(50)	是
//        model_dispidx	显示顺序	int4	是
//        model_user_id	提交人id	varchar(42)	是
//        model_user_name	提交人姓名	varchar(64)	是
//        model_ctime	创建时间	timestamp(6)	是
//        model_mtime	修改时间	timestamp(6)	是
