package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import java.sql.Timestamp;
@Data
@Accessors(chain = true)
@TableName("ocp_api_audit")
@ApiModel("服务事记表")
public class OcpApiAudit {

  @TableId(type = IdType.ASSIGN_ID)
  @ApiModelProperty("主键ID")
  private String objId;

  @ApiModelProperty("服务编码")
  private String apiCode;

  @ApiModelProperty("操作状态0:新增,1:迭代；2，下线")
  private long operStatus;

  @ApiModelProperty("操作对象0:服务，1:入参，2:出参")
  private long operTarget;

  @ApiModelProperty("类型0:人工操作,1:流程管控,3:总部下发")
  private long auditType;

  @ApiModelProperty("备注简述")
  private String auditMessage;

  @ApiModelProperty("事记内容")
  private String auditJson;

  @ApiModelProperty("提交人id")
  private String auditUserId;

  @ApiModelProperty("提交人姓名")
  private String auditUserName;

  @ApiModelProperty("创建时间")
  private Timestamp auditCtime;

  @ApiModelProperty("修改时间")
  private Timestamp auditMtime;

  @ApiModelProperty("是否删除0-否1-是")
  private long isDelete;
  @ApiModelProperty("当前版本")
  private long applyVersion;
  @ApiModelProperty("上一版本")
  private long preApplyVersion;

  public long getApplyVersion() {
    return applyVersion;
  }

  public void setApplyVersion(long applyVersion) {
    this.applyVersion = applyVersion;
  }

  public long getPreApplyVersion() {
    return preApplyVersion;
  }

  public void setPreApplyVersion(long preApplyVersion) {
    this.preApplyVersion = preApplyVersion;
  }

  public String getObjId() {
    return objId;
  }

  public void setObjId(String objId) {
    this.objId = objId;
  }


  public String getApiCode() {
    return apiCode;
  }

  public void setApiCode(String apiCode) {
    this.apiCode = apiCode;
  }


  public long getOperStatus() {
    return operStatus;
  }

  public void setOperStatus(long operStatus) {
    this.operStatus = operStatus;
  }


  public long getOperTarget() {
    return operTarget;
  }

  public void setOperTarget(long operTarget) {
    this.operTarget = operTarget;
  }


  public long getAuditType() {
    return auditType;
  }

  public void setAuditType(long auditType) {
    this.auditType = auditType;
  }


  public String getAuditMessage() {
    return auditMessage;
  }

  public void setAuditMessage(String auditMessage) {
    this.auditMessage = auditMessage;
  }


  public String getAuditJson() {
    return auditJson;
  }

  public void setAuditJson(String auditJson) {
    this.auditJson = auditJson;
  }


  public String getAuditUserId() {
    return auditUserId;
  }

  public void setAuditUserId(String auditUserId) {
    this.auditUserId = auditUserId;
  }


  public String getAuditUserName() {
    return auditUserName;
  }

  public void setAuditUserName(String auditUserName) {
    this.auditUserName = auditUserName;
  }


  public Timestamp getAuditCtime() {
    return auditCtime;
  }

  public void setAuditCtime(Timestamp auditCtime) {
    this.auditCtime = auditCtime;
  }


  public Timestamp getAuditMtime() {
    return auditMtime;
  }

  public void setAuditMtime(Timestamp auditMtime) {
    this.auditMtime = auditMtime;
  }


  public long getIsDelete() {
    return isDelete;
  }

  public void setIsDelete(long isDelete) {
    this.isDelete = isDelete;
  }

}
