package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import java.sql.Timestamp;

@Data
@Accessors(chain = true)
@TableName("ocp_api_Tenant_rel")
@ApiModel("服务应用关系表")
public class OcpApiTenantRel {

  @TableId(type = IdType.ASSIGN_ID)
  @ApiModelProperty("主键ID")
  private String objId;

  @ApiModelProperty("应用编码")
  private String tenantCode;

  @ApiModelProperty("服务编码")
  private String apiCode;

  @ApiModelProperty("服务部署公司")
  private String apiDepCompanyCode;

  @ApiModelProperty("应用所属公司")
  private String tenantDepCompanyCode;

  @ApiModelProperty("关系创建时间")
  private Timestamp apiTenantRelCtime;

  @ApiModelProperty("关系创建时间")
  private Timestamp apiTenantRelMtime;

  @ApiModelProperty("关系创建用户ID")
  private String apiTenantRelUserId;

  @ApiModelProperty("关系创建用户")
  private String apiTenantRelUserName;

  @ApiModelProperty("是否已删除0未删除，1已删除")
  private long isDelete;


  public String getObjId() {
    return objId;
  }

  public void setObjId(String objId) {
    this.objId = objId;
  }


  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }


  public String getApiCode() {
    return apiCode;
  }

  public void setApiCode(String apiCode) {
    this.apiCode = apiCode;
  }


  public String getApiDepCompanyCode() {
    return apiDepCompanyCode;
  }

  public void setApiDepCompanyCode(String apiDepCompanyCode) {
    this.apiDepCompanyCode = apiDepCompanyCode;
  }


  public String getTenantDepCompanyCode() {
    return tenantDepCompanyCode;
  }

  public void setTenantDepCompanyCode(String tenantDepCompanyCode) {
    this.tenantDepCompanyCode = tenantDepCompanyCode;
  }


  public Timestamp getApiTenantRelCtime() {
    return apiTenantRelCtime;
  }

  public void setApiTenantRelCtime(Timestamp apiTenantRelCtime) {
    this.apiTenantRelCtime = apiTenantRelCtime;
  }


  public Timestamp getApiTenantRelMtime() {
    return apiTenantRelMtime;
  }

  public void setApiTenantRelMtime(Timestamp apiTenantRelMtime) {
    this.apiTenantRelMtime = apiTenantRelMtime;
  }


  public String getApiTenantRelUserId() {
    return apiTenantRelUserId;
  }

  public void setApiTenantRelUserId(String apiTenantRelUserId) {
    this.apiTenantRelUserId = apiTenantRelUserId;
  }


  public String getApiTenantRelUserName() {
    return apiTenantRelUserName;
  }

  public void setApiTenantRelUserName(String apiTenantRelUserName) {
    this.apiTenantRelUserName = apiTenantRelUserName;
  }


  public long getIsDelete() {
    return isDelete;
  }

  public void setIsDelete(long isDelete) {
    this.isDelete = isDelete;
  }

}
