package com.pms.ocp.model.vo;

import com.pms.ocp.common.constants.CodeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author wuwanli
 * @version 1.0
 * @date 2021/8/5
 */

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "返回对象", description = "返回对象")
public class ResponseVO<T> extends BaseResponse {
    private static final long serialVersionUID = 2445069102311188334L;
    /**
     * 封装的返回对象
     */
    @ApiModelProperty(value = "封装的返回对象")
    private T data;

    public ResponseVO() {
        super();
    }

    public ResponseVO(CodeEnum codeEnum) {
        this.setCode(codeEnum.getCode());
        this.setDesc(codeEnum.getDesc());
        this.setSuccess(codeEnum.isSuccess());
    }


    public static <T> ResponseVO<T> ok() {
        return new ResponseVO<>(CodeEnum.SUCCESS);
    }

    public static <T> ResponseVO<T> ok(T data) {
        ResponseVO<T> r = new ResponseVO<T>(CodeEnum.SUCCESS);
        r.setData(data);
        return r;
    }

    public static <T> ResponseVO<T> error(CodeEnum codeEnum) {
        return new ResponseVO<T>(codeEnum);
    }

    public static <T> ResponseVO<T> error(String msg) {
        ResponseVO<T> tResponseVO = new ResponseVO<>();
        tResponseVO.setCode("0");
        tResponseVO.setDesc(msg);
        tResponseVO.setSuccess(false);
        return tResponseVO;
    }

}