package com.pms.ocp.service;

import com.pms.ocp.common.constants.CodeEnum;
import com.pms.ocp.model.entity.Model;
import com.pms.ocp.model.entity.ModelType;
import com.pms.ocp.model.vo.ResponseVO;

import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:03
 * @Description:模型业务层接口
 */
public interface ModelService {

    /**
     * 创建模型
     *
     * @param model
     * @return
     */
    ResponseVO createModel(Model model);

    /**
     * 删除模型
     *
     * @param modelId
     * @return
     */
    ResponseVO deleteModel(String modelId);

    /**
     * 更新模型
     *
     * @param model
     * @return
     */
    ResponseVO updateModel(Model model);

    /**
     * 获取模型
     *
     * @param
     * @return
     */
    ResponseVO getModelList();

    /**
     * 获取模型列表
     *
     * @param modelId
     * @return
     */
    Model getModel(String modelId);

}
