package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.common.config.PageParam;
import com.pms.ocp.common.utils.RandomStringUtil;
import com.pms.ocp.mapper.OcpApiBaseMapper;
import com.pms.ocp.mapper.OcpApiTreeMapper;
import com.pms.ocp.model.dto.*;
import com.pms.ocp.model.entity.OcpApiBase;
import com.pms.ocp.model.entity.OcpApiGroup;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.OcpApiTreeService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;


@Service
@Slf4j
public class OcpApiTreeServiceImpl extends ServiceImpl<OcpApiTreeMapper,OcpApiGroup> implements OcpApiTreeService {


    @Autowired
    private OcpApiTreeMapper mapper;

    @Autowired
    private OcpApiBaseMapper ocpApiBaseMapper;

    /**
     * 服务树分类
     *
     * @return
     */

    @Override
    public ApiTreeGroupDto getByGroup() {

        //服务树全表数据
        List<OcpApiGroup> ocpApiGroups = mapper.selectList(null);


        //服务树分类对象
        ApiTreeGroupDto apiTreeGroupList = new ApiTreeGroupDto();
        //1中台层
        List<OneTreeUpList> oneTreeUpLists = new ArrayList<>();

        for (OcpApiGroup ocpApiGroup : ocpApiGroups) {
            //判断数据状态
            if (!(ocpApiGroup.getIsDelete() == 0)) {
                //一级服务对象
                OneTreeUpList oneTreeUpList = new OneTreeUpList();
//                判断数据是否有上级服务分类
                if (ocpApiGroup.getApiGroupLevel() == 1) {
                    BeanUtils.copyProperties(ocpApiGroup, oneTreeUpList);
                    oneTreeUpLists.add(oneTreeUpList);
                }
            }
        }
        List<TwoDownList> twoDownLists = twoTreeLists(oneTreeUpLists, ocpApiGroups);
        List<ThreeTreeList> threeTreeLists = threeTreeLists(twoDownLists, ocpApiGroups);
        List<FourTreeList> fourTreeLists = fourTreeLists(threeTreeLists, ocpApiGroups);
        apiTreeGroupList.setOneList(oneTreeUpLists);
        apiTreeGroupList.setTwoList(twoDownLists);
        apiTreeGroupList.setThreeList(threeTreeLists);
        apiTreeGroupList.setFourList(fourTreeLists);


        return apiTreeGroupList;
    }

    /**
     * 2中心层
     *
     * @param oneTreeUpLists
     * @return
     */
    public List<TwoDownList> twoTreeLists(List<OneTreeUpList> oneTreeUpLists, List<OcpApiGroup> ocpApiGroups) {

        /*  List<OcpApiGroup> groupList = new ArrayList<>();*/
        List<TwoDownList> twoTreeLists = new ArrayList<>();
        for (OcpApiGroup ocpApiGroup : ocpApiGroups) {
            TwoDownList twoDownList = new TwoDownList();
            if (!(ocpApiGroup.getIsDelete() == 0)) {
                if (ocpApiGroup.getApiGroupLevel() == 2) {
                    BeanUtils.copyProperties(ocpApiGroup, twoDownList);
                    twoTreeLists.add(twoDownList);
                } else {
                    continue;
                }
            }
        }

        return twoTreeLists;

    }

    /**
     * 3服务组层
     *
     * @param twoDownLists
     * @return
     */
    public List<ThreeTreeList> threeTreeLists(List<TwoDownList> twoDownLists, List<OcpApiGroup> ocpApiGroups) {
        List<ThreeTreeList> threeTreeLists = new ArrayList<>();
        for (OcpApiGroup ocpApiGroup : ocpApiGroups) {
            ThreeTreeList threeTreeList = new ThreeTreeList();
            if (!(ocpApiGroup.getIsDelete() == 0)) {
                if (ocpApiGroup.getApiGroupLevel() == 3) {
                    BeanUtils.copyProperties(ocpApiGroup, threeTreeList);
                    threeTreeLists.add(threeTreeList);
                }
            } else {
                continue;
            }

        }
        return threeTreeLists;

    }

    /**
     * 4服务层
     *
     * @param threeTreeLists
     * @return
     */
    public List<FourTreeList> fourTreeLists(List<ThreeTreeList> threeTreeLists, List<OcpApiGroup> ocpApiGroups) {
        List<FourTreeList> foureTreeList = new ArrayList<>();
        for (OcpApiGroup ocpApiGroup : ocpApiGroups) {
            FourTreeList fourTreeList = new FourTreeList();
            if (!(ocpApiGroup.getIsDelete() == 0)) {
                if (ocpApiGroup.getApiGroupLevel() == 4) {
                    BeanUtils.copyProperties(fourTreeList, foureTreeList);
                    foureTreeList.add(fourTreeList);
                }
            } else {
                continue;
            }

        }
        return foureTreeList;

    }

    /**
     * 新增服务分类
     *
     * @param ocpApiGroupDtos
     */
    @Override
    public boolean insertTree(OcpApiGroupDtos ocpApiGroupDtos) {


        String code = RandomStringUtil.getRandomString(6);
        boolean flag = true;
        List<OcpApiGroup> ocpApiGroups = mapper.selectList(null);
        for (OcpApiGroup ocpApiGroup : ocpApiGroups) {
            if (ocpApiGroup.getApiGroupCode().equals(ocpApiGroupDtos.getApiGroupCode())) {
                flag = false;
                break;
            }
        }
        if (flag == true) {
            OcpApiBase ocpApiBase = new OcpApiBase();
            ocpApiBase.setApiCode(ocpApiGroupDtos.getApiGroupCode());
            BeanUtils.copyProperties(ocpApiGroupDtos, ocpApiBase);
            ocpApiBase.setApiGroupCode(code);
            ocpApiBase.setApiName("新增服务分类");
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            ocpApiBase.setApiMtime(timestamp);
            ocpApiBase.setApiCtime(ocpApiGroupDtos.getApiGroupCtime());
            ocpApiBase.setApiUserId(ocpApiGroupDtos.getApiGroupUserId());
            ocpApiBase.setObjId("");
            OcpApiGroup ocpApiGroup1 = new OcpApiGroup();
            ocpApiGroup1.setObjId("");
            BeanUtils.copyProperties(ocpApiGroupDtos, ocpApiGroup1);
            ocpApiGroup1.setApiGroupCode(code);
            ocpApiBaseMapper.insert(ocpApiBase);
            mapper.insert(ocpApiGroup1);

        }
        return flag;

    }


    /**
     * 修改服务分类
     *
     * @param
     */
    @Override
    public boolean updataOcpTree(OcpApiGroup ocpApiGroup) {
        boolean falg = true;
        List<OcpApiGroup> ocpApiGroups = mapper.selectList(null);
        for (OcpApiGroup apiGroup : ocpApiGroups) {
            String code = apiGroup.getApiGroupCode();
            if (code == ocpApiGroup.getApiGroupCode()) {
                falg = false;
                break;
            }
        }
        mapper.updateById(ocpApiGroup);
        return falg;
    }


    /**
     * 删除服务分类
     *
     * @param ocpApiGroup
     */
    @Override
    public boolean deleteOcpTree(OcpApiGroup ocpApiGroup) {
        String objId = ocpApiGroup.getObjId();
        OcpApiGroup ocpApiGroup1 = mapper.selectById(objId);
        if (StringUtils.isBlank(ocpApiGroup1.getApiGroupPcode())) {
            mapper.deleteById(objId);
            return true;
        } else {
            return false;
        }
    }



 /*   *//**
     * 一级服务
     *
     * @param
     *//*
    @Override
    public List<OcpApiGroup> getOnePage(int pageSize, int pageNum, int apiGroupLevel) {

         Page pageInfo = new Page(pageSize,pageNum);
        LambdaQueryWrapper<OcpApiGroup> queryWrapper = new LambdaQueryWrapper();
        LambdaQueryWrapper<OcpApiGroup> eq = queryWrapper.eq(OcpApiGroup::getApiGroupLevel, apiGroupLevel);
        List<OcpApiGroup> ocpApiGroups = mapper.selectList(eq);
        return ocpApiGroups;
    }*/

    /**
     * 服务列表分级查询
     *
     * @param pageGroupDto
     * @return
     */
    @Override
    public Page<OcpApiGroup> getOnePages(PageGroupDto pageGroupDto) {
        Page pageInfo = new Page(pageGroupDto.getPageSize(), pageGroupDto.getPageNum());
        if (pageGroupDto.getApiGroupLevel() == 1 && "".equals(pageGroupDto.getApiGroupPcode())) {
            LambdaQueryWrapper<OcpApiGroup> queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(OcpApiGroup::getApiGroupLevel, pageGroupDto.getApiGroupLevel());
            mapper.selectPage(pageInfo,queryWrapper);
        }else if (pageGroupDto.getApiGroupLevel() == 2){
            List<OcpApiGroup> ocpApiGroups = mapper.selectList(null);
            for (OcpApiGroup ocpApiGroup : ocpApiGroups) {
                if (pageGroupDto.getApiGroupCode() == ocpApiGroup.getApiGroupCode()){
                    LambdaQueryWrapper<OcpApiGroup> queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(OcpApiGroup::getApiGroupLevel, pageGroupDto.getApiGroupLevel());
                    mapper.selectPage(pageInfo,queryWrapper);
                }
            }

        }else if (pageGroupDto.getApiGroupLevel() == 3){
            List<OcpApiGroup> ocpApiGroups = mapper.selectList(null);
            for (OcpApiGroup ocpApiGroup : ocpApiGroups) {
                if (pageGroupDto.getApiGroupCode() == ocpApiGroup.getApiGroupCode()) {
                    LambdaQueryWrapper<OcpApiGroup> queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(OcpApiGroup::getApiGroupLevel, pageGroupDto.getApiGroupLevel());
                    mapper.selectPage(pageInfo, queryWrapper);
                }
            }
        }else {
            List<OcpApiGroup> ocpApiGroups = mapper.selectList(null);
            for (OcpApiGroup ocpApiGroup : ocpApiGroups) {
                if (pageGroupDto.getApiGroupCode() == ocpApiGroup.getApiGroupCode()) {
                    LambdaQueryWrapper<OcpApiGroup> queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(OcpApiGroup::getApiGroupLevel, pageGroupDto.getApiGroupLevel());
                    mapper.selectPage(pageInfo, queryWrapper);
                }
            }

        }
        return pageInfo;

    }



}
