package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import java.sql.Timestamp;

@Data
@Accessors(chain = true)
@TableName("ocp_api_model_rel")
@ApiModel("服务模型关系")
public class OcpApiModelRel {

  @TableId(type = IdType.ASSIGN_ID)
  @ApiModelProperty("主键ID")
  private String objId;

  @ApiModelProperty("模型编码")
  private String modelCode;

  @ApiModelProperty("模型部署公司")
  private String modelDepCompanyCode;

  @ApiModelProperty("服务编码")
  private String apiCode;

  @ApiModelProperty("服务部署公司")
  private String apiDepCompanyCode;

  @ApiModelProperty("关系添加时间")
  private Timestamp relationCtime;

  @ApiModelProperty("是否已删除 0-否1-是")
  private long isDelete;


  public String getObjId() {
    return objId;
  }

  public void setObjId(String objId) {
    this.objId = objId;
  }


  public String getModelCode() {
    return modelCode;
  }

  public void setModelCode(String modelCode) {
    this.modelCode = modelCode;
  }


  public String getModelDepCompanyCode() {
    return modelDepCompanyCode;
  }

  public void setModelDepCompanyCode(String modelDepCompanyCode) {
    this.modelDepCompanyCode = modelDepCompanyCode;
  }


  public String getApiCode() {
    return apiCode;
  }

  public void setApiCode(String apiCode) {
    this.apiCode = apiCode;
  }


  public String getApiDepCompanyCode() {
    return apiDepCompanyCode;
  }

  public void setApiDepCompanyCode(String apiDepCompanyCode) {
    this.apiDepCompanyCode = apiDepCompanyCode;
  }


  public Timestamp getRelationCtime() {
    return relationCtime;
  }

  public void setRelationCtime(Timestamp relationCtime) {
    this.relationCtime = relationCtime;
  }


  public long getIsDelete() {
    return isDelete;
  }

  public void setIsDelete(long isDelete) {
    this.isDelete = isDelete;
  }

}
