package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 应用事记表
 * @TableName ocp_tenant_audit
 */
@Data
@Accessors(chain = true)
@TableName("ocp_tenant_audit")
@ApiModel("应用事记表1")
public class OcpTenantAudit implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("主键ID")
    private String objId;

    /**
     * 应用code
     */
    @ApiModelProperty("应用code")
    private String tenantCode;

    /**
     * 操作状态0:新增,1:迭代；2，下线
     */
    @ApiModelProperty("操作状态0:新增,1:迭代；2，下线")
    private Short operStatus;

    /**
     * 类型0:人工操作,1:流程管控,3:总部下发
     */
    @ApiModelProperty("类型0:人工操作,1:流程管控,3:总部下发")
    private Short auditType;

    /**
     * 备注简述
     */
    @ApiModelProperty("备注简述")
    private String auditMessage;

    /**
     * 应用事记内容
     */
    @ApiModelProperty("应用事记内容")
    private String auditJson;

    /**
     * 提交人id
     */
    @ApiModelProperty("提交人id")
    private String auditUserId;

    /**
     * 提交人姓名
     */
    @ApiModelProperty("提交人姓名")
    private String auditUserName;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date auditCtime;

    /**
     * 应用版本(当前版本)
     */
    @ApiModelProperty(" 应用版本(当前版本")
    private String applyVersion;

    /**
     * 上一版本
     */
    @ApiModelProperty("上一版本")
    private String perTenantVersion;

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    public String getObjId() {
        return objId;
    }

    /**
     * 主键
     */
    public void setObjId(String objId) {
        this.objId = objId;
    }

    /**
     * 应用code
     */
    public String getTenantCode() {
        return tenantCode;
    }

    /**
     * 应用code
     */
    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    /**
     * 操作状态0:新增,1:迭代；2，下线
     */
    public Short getOperStatus() {
        return operStatus;
    }

    /**
     * 操作状态0:新增,1:迭代；2，下线
     */
    public void setOperStatus(Short operStatus) {
        this.operStatus = operStatus;
    }

    /**
     * 类型0:人工操作,1:流程管控,3:总部下发
     */
    public Short getAuditType() {
        return auditType;
    }

    /**
     * 类型0:人工操作,1:流程管控,3:总部下发
     */
    public void setAuditType(Short auditType) {
        this.auditType = auditType;
    }

    /**
     * 备注简述
     */
    public String getAuditMessage() {
        return auditMessage;
    }

    /**
     * 备注简述
     */
    public void setAuditMessage(String auditMessage) {
        this.auditMessage = auditMessage;
    }

    /**
     * 应用事记内容
     */
    public String getAuditJson() {
        return auditJson;
    }

    /**
     * 应用事记内容
     */
    public void setAuditJson(String auditJson) {
        this.auditJson = auditJson;
    }

    /**
     * 提交人id
     */
    public String getAuditUserId() {
        return auditUserId;
    }

    /**
     * 提交人id
     */
    public void setAuditUserId(String auditUserId) {
        this.auditUserId = auditUserId;
    }

    /**
     * 提交人姓名
     */
    public String getAuditUserName() {
        return auditUserName;
    }

    /**
     * 提交人姓名
     */
    public void setAuditUserName(String auditUserName) {
        this.auditUserName = auditUserName;
    }

    /**
     * 创建时间
     */
    public Date getAuditCtime() {
        return auditCtime;
    }

    /**
     * 创建时间
     */
    public void setAuditCtime(Date auditCtime) {
        this.auditCtime = auditCtime;
    }

    /**
     * 应用版本(当前版本)
     */
    public String getApplyVersion() {
        return applyVersion;
    }

    /**
     * 应用版本(当前版本)
     */
    public void setApplyVersion(String applyVersion) {
        this.applyVersion = applyVersion;
    }

    /**
     * 上一版本
     */
    public String getPerTenantVersion() {
        return perTenantVersion;
    }

    /**
     * 上一版本
     */
    public void setPerTenantVersion(String perTenantVersion) {
        this.perTenantVersion = perTenantVersion;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        OcpTenantAudit other = (OcpTenantAudit) that;
        return (this.getObjId() == null ? other.getObjId() == null : this.getObjId().equals(other.getObjId()))
            && (this.getTenantCode() == null ? other.getTenantCode() == null : this.getTenantCode().equals(other.getTenantCode()))
            && (this.getOperStatus() == null ? other.getOperStatus() == null : this.getOperStatus().equals(other.getOperStatus()))
            && (this.getAuditType() == null ? other.getAuditType() == null : this.getAuditType().equals(other.getAuditType()))
            && (this.getAuditMessage() == null ? other.getAuditMessage() == null : this.getAuditMessage().equals(other.getAuditMessage()))
            && (this.getAuditJson() == null ? other.getAuditJson() == null : this.getAuditJson().equals(other.getAuditJson()))
            && (this.getAuditUserId() == null ? other.getAuditUserId() == null : this.getAuditUserId().equals(other.getAuditUserId()))
            && (this.getAuditUserName() == null ? other.getAuditUserName() == null : this.getAuditUserName().equals(other.getAuditUserName()))
            && (this.getAuditCtime() == null ? other.getAuditCtime() == null : this.getAuditCtime().equals(other.getAuditCtime()))
            && (this.getApplyVersion() == null ? other.getApplyVersion() == null : this.getApplyVersion().equals(other.getApplyVersion()))
            && (this.getPerTenantVersion() == null ? other.getPerTenantVersion() == null : this.getPerTenantVersion().equals(other.getPerTenantVersion()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getObjId() == null) ? 0 : getObjId().hashCode());
        result = prime * result + ((getTenantCode() == null) ? 0 : getTenantCode().hashCode());
        result = prime * result + ((getOperStatus() == null) ? 0 : getOperStatus().hashCode());
        result = prime * result + ((getAuditType() == null) ? 0 : getAuditType().hashCode());
        result = prime * result + ((getAuditMessage() == null) ? 0 : getAuditMessage().hashCode());
        result = prime * result + ((getAuditJson() == null) ? 0 : getAuditJson().hashCode());
        result = prime * result + ((getAuditUserId() == null) ? 0 : getAuditUserId().hashCode());
        result = prime * result + ((getAuditUserName() == null) ? 0 : getAuditUserName().hashCode());
        result = prime * result + ((getAuditCtime() == null) ? 0 : getAuditCtime().hashCode());
        result = prime * result + ((getApplyVersion() == null) ? 0 : getApplyVersion().hashCode());
        result = prime * result + ((getPerTenantVersion() == null) ? 0 : getPerTenantVersion().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", objId=").append(objId);
        sb.append(", tenantCode=").append(tenantCode);
        sb.append(", operStatus=").append(operStatus);
        sb.append(", auditType=").append(auditType);
        sb.append(", auditMessage=").append(auditMessage);
        sb.append(", auditJson=").append(auditJson);
        sb.append(", auditUserId=").append(auditUserId);
        sb.append(", auditUserName=").append(auditUserName);
        sb.append(", auditCtime=").append(auditCtime);
        sb.append(", applyVersion=").append(applyVersion);
        sb.append(", perTenantVersion=").append(perTenantVersion);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}