package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 应用订阅记录表
 * @TableName ocp_tenant_subs
 */
@Data
@Accessors(chain = true)
@TableName("ocp_tenant_subs")
@ApiModel("应用订阅记录表1")
public class OcpTenantSubs implements Serializable {
    /**
     * 关系ID
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("关系ID")
    private String objId;

    /**
     * 服务编码
     */
    @ApiModelProperty("服务编码")
    private String tenantCode;

    /**
     * 订阅公司编码
     */
    @ApiModelProperty("订阅公司编码")
    private String subsCompanyCode;

    /**
     * 服务订阅创建时间
     */
    @ApiModelProperty("服务订阅创建时间")
    private Date subsLogTenantCtime;

    /**
     * 服务订阅修改时间
     */
    @ApiModelProperty("服务订阅修改时间")
    private Date subsLogTenantMtime;

    /**
     * 服务订阅创建用户ID
     */
    @ApiModelProperty("服务订阅创建用户ID")
    private String subsLogTenantUserId;

    /**
     * 服务订阅添加时间
     */
    @ApiModelProperty("服务订阅添加时间")
    private Date subsLogTenantAtime;

    /**
     * 是否删除0-否，1-是
     */
    @ApiModelProperty("是否删除0-否，1-是")
    private Short isDelete;

    private static final long serialVersionUID = 1L;

    /**
     * 关系ID
     */
    public String getObjId() {
        return objId;
    }

    /**
     * 关系ID
     */
    public void setObjId(String objId) {
        this.objId = objId;
    }

    /**
     * 服务编码
     */
    public String getTenantCode() {
        return tenantCode;
    }

    /**
     * 服务编码
     */
    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    /**
     * 订阅公司编码
     */
    public String getSubsCompanyCode() {
        return subsCompanyCode;
    }

    /**
     * 订阅公司编码
     */
    public void setSubsCompanyCode(String subsCompanyCode) {
        this.subsCompanyCode = subsCompanyCode;
    }

    /**
     * 服务订阅创建时间
     */
    public Date getSubsLogTenantCtime() {
        return subsLogTenantCtime;
    }

    /**
     * 服务订阅创建时间
     */
    public void setSubsLogTenantCtime(Date subsLogTenantCtime) {
        this.subsLogTenantCtime = subsLogTenantCtime;
    }

    /**
     * 服务订阅修改时间
     */
    public Date getSubsLogTenantMtime() {
        return subsLogTenantMtime;
    }

    /**
     * 服务订阅修改时间
     */
    public void setSubsLogTenantMtime(Date subsLogTenantMtime) {
        this.subsLogTenantMtime = subsLogTenantMtime;
    }

    /**
     * 服务订阅创建用户ID
     */
    public String getSubsLogTenantUserId() {
        return subsLogTenantUserId;
    }

    /**
     * 服务订阅创建用户ID
     */
    public void setSubsLogTenantUserId(String subsLogTenantUserId) {
        this.subsLogTenantUserId = subsLogTenantUserId;
    }

    /**
     * 服务订阅添加时间
     */
    public Date getSubsLogTenantAtime() {
        return subsLogTenantAtime;
    }

    /**
     * 服务订阅添加时间
     */
    public void setSubsLogTenantAtime(Date subsLogTenantAtime) {
        this.subsLogTenantAtime = subsLogTenantAtime;
    }

    /**
     * 是否删除0-否，1-是
     */
    public Short getIsDelete() {
        return isDelete;
    }

    /**
     * 是否删除0-否，1-是
     */
    public void setIsDelete(Short isDelete) {
        this.isDelete = isDelete;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        OcpTenantSubs other = (OcpTenantSubs) that;
        return (this.getObjId() == null ? other.getObjId() == null : this.getObjId().equals(other.getObjId()))
            && (this.getTenantCode() == null ? other.getTenantCode() == null : this.getTenantCode().equals(other.getTenantCode()))
            && (this.getSubsCompanyCode() == null ? other.getSubsCompanyCode() == null : this.getSubsCompanyCode().equals(other.getSubsCompanyCode()))
            && (this.getSubsLogTenantCtime() == null ? other.getSubsLogTenantCtime() == null : this.getSubsLogTenantCtime().equals(other.getSubsLogTenantCtime()))
            && (this.getSubsLogTenantMtime() == null ? other.getSubsLogTenantMtime() == null : this.getSubsLogTenantMtime().equals(other.getSubsLogTenantMtime()))
            && (this.getSubsLogTenantUserId() == null ? other.getSubsLogTenantUserId() == null : this.getSubsLogTenantUserId().equals(other.getSubsLogTenantUserId()))
            && (this.getSubsLogTenantAtime() == null ? other.getSubsLogTenantAtime() == null : this.getSubsLogTenantAtime().equals(other.getSubsLogTenantAtime()))
            && (this.getIsDelete() == null ? other.getIsDelete() == null : this.getIsDelete().equals(other.getIsDelete()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getObjId() == null) ? 0 : getObjId().hashCode());
        result = prime * result + ((getTenantCode() == null) ? 0 : getTenantCode().hashCode());
        result = prime * result + ((getSubsCompanyCode() == null) ? 0 : getSubsCompanyCode().hashCode());
        result = prime * result + ((getSubsLogTenantCtime() == null) ? 0 : getSubsLogTenantCtime().hashCode());
        result = prime * result + ((getSubsLogTenantMtime() == null) ? 0 : getSubsLogTenantMtime().hashCode());
        result = prime * result + ((getSubsLogTenantUserId() == null) ? 0 : getSubsLogTenantUserId().hashCode());
        result = prime * result + ((getSubsLogTenantAtime() == null) ? 0 : getSubsLogTenantAtime().hashCode());
        result = prime * result + ((getIsDelete() == null) ? 0 : getIsDelete().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", objId=").append(objId);
        sb.append(", tenantCode=").append(tenantCode);
        sb.append(", subsCompanyCode=").append(subsCompanyCode);
        sb.append(", subsLogTenantCtime=").append(subsLogTenantCtime);
        sb.append(", subsLogTenantMtime=").append(subsLogTenantMtime);
        sb.append(", subsLogTenantUserId=").append(subsLogTenantUserId);
        sb.append(", subsLogTenantAtime=").append(subsLogTenantAtime);
        sb.append(", isDelete=").append(isDelete);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}