package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.pms.ocp.common.constants.CodeEnum;
import com.pms.ocp.mapper.ModelTypeMapper;
import com.pms.ocp.model.entity.ModelType;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.ModelGroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service
public class ModelGroupServiceImpl implements ModelGroupService {

    @Autowired
    private ModelTypeMapper modelTypeMapper;

    /**
     * 获取模型类型
     * @return
     */
    @Override
    public ResponseVO getModelType() {
        QueryWrapper<ModelType> wrapper = new QueryWrapper<>();
        List<ModelType> modelTypeList = modelTypeMapper.selectList(wrapper);
        if(CollectionUtils.isEmpty(modelTypeList)){
            return ResponseVO.error("查询列表为空");
        }else{
            return ResponseVO.ok(modelTypeList);
        }
    }

    @Override
    public ResponseVO createModelType(ModelType modelType) {
        int result = modelTypeMapper.insert(modelType);
        if(result>0){
            return ResponseVO.error(CodeEnum.SUCCESS);
        }else{
            return ResponseVO.ok(CodeEnum.INSERT_FAIL);
        }
    }

    @Override
    public ResponseVO deleteModelType(String modelTypeId) {
        int result = modelTypeMapper.deleteById(modelTypeId);
        if (result > 0) {
            return ResponseVO.error(CodeEnum.SUCCESS);
        } else {
            return ResponseVO.ok(CodeEnum.UNKNOWN);
        }
    }

    @Override
    public ResponseVO updateModelType(ModelType modelType) {
        int result = modelTypeMapper.updateById(modelType);
        if (result > 0) {
            return ResponseVO.error(CodeEnum.SUCCESS);
        } else {
            return ResponseVO.ok(CodeEnum.UP_DATA_FAIL);
        }
    }
}
