package com.pms.ocp.common.exception;

import lombok.Getter;

/**
 * @author wuwanli
 * @date 2021/8/3
 */
public class BeagleException extends RuntimeException {
	/**
	 * 错误码
	 */
	@Getter
	protected String errorCode;
	/**
	 * 错误信息
	 */
	@Getter
	protected String errorMsg;

	public BeagleException() {
		super();
	}

	public BeagleException(String errorMsg) {
		super(errorMsg);
		this.errorMsg = errorMsg;
	}
	public BeagleException(String errorCode, String errorMsg) {
		super(errorMsg);
		this.errorCode = errorCode;
		this.errorMsg = errorMsg;
	}

	public BeagleException(String errorMsg, Throwable cause) {
		super(errorMsg, cause);
	}

	public BeagleException(String errorCode, String errorMsg, Throwable cause) {
		super(errorCode, cause);
		this.errorCode = errorCode;
		this.errorMsg = errorMsg;
	}
}
