package com.pms.ocp.controller;

import com.pms.ocp.model.dto.OcpApiBaseDto;
import com.pms.ocp.model.dto.OcpTenantBaseDto;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.TenantBasicManagementService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.sql.Timestamp;
import java.util.List;

@Slf4j
@RequestMapping("/tenant/basic")
@RestController
@Api(tags = "应用库服务基础管理接口")
public class TenantBasicManagementController {
    @Autowired
    private TenantBasicManagementService tenantBasicManagementService;

    @ApiOperation("条件查询")
    @GetMapping("/queryOcpTenantBaseDto")
    public ResponseVO<List<OcpTenantBaseDto>> queryOcpTenantBaseDto(
            @RequestParam(required = false) String tenantCode,
            @RequestParam(required = false) String keyword,
            @RequestParam(required = false) String tenantUnit,
            @RequestParam(required = false) Timestamp startTime,
            @RequestParam(required = false) Timestamp endTime,
            @RequestParam(required = false) Integer pageSize,
            @RequestParam(required = false) Integer pageNum
    ) {
        List<OcpTenantBaseDto> ocpTenantBaseDto = tenantBasicManagementService.queryOcpTenantBaseDto(tenantCode, keyword, tenantUnit, startTime, endTime, pageSize
                , pageNum);
        return ResponseVO.ok(ocpTenantBaseDto);
    }

    @ApiOperation("应用发布")
    @PostMapping("/issue")
    public ResponseVO TenantIssue(@RequestParam(required = false) String tenantPromotion,
                                  @RequestParam(required = false) String tenantCodes) {
        if (StringUtils.isEmpty(tenantPromotion) || tenantPromotion.equals("0")) {
            return ResponseVO.error("统招");
        } else {
            return tenantBasicManagementService.tenantIssue(tenantCodes);
        }
    }

    @ApiOperation("应用订阅")
    @PostMapping("/login")
    public ResponseVO TenantLogin(@RequestParam(required = false) String tenantPromotion,
                                  @RequestParam(required = false) String tenantCodes) {
        if (StringUtils.isEmpty(tenantPromotion) || tenantPromotion.equals("0")) {
            return ResponseVO.error("统招");
        } else {
            tenantBasicManagementService.tenantLogin(tenantCodes);
            return ResponseVO.ok();
        }

    }

    @ApiOperation("应用下线")
    @PostMapping("/cancel")
    public ResponseVO TenantCancel(
            @RequestParam(required = false) String tenantCodes) {
        return tenantBasicManagementService.tenantCancel(tenantCodes);

    }
    @ApiOperation("应用注册")
    @PostMapping("/apply/register")
    public ResponseVO TenantRegister(@RequestBody(required = false) OcpTenantBaseDto ocpTenantBaseDto){

        return ResponseVO.ok();
    }

}
