package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:40
 * @Description:模型订阅对象
 */

@Data
@Accessors(chain = true)
@TableName("ocp_model_subs")
public class ModelIssue {

    /**
     * 模型订阅编号
     */
    @TableId(value = "obj_id")
    private String objId;

    /**
     * 模型编码
     */
    private String modelCode;

    /**
     * 订阅状态 0:订阅, 1:取消订阅
     */
    private int subsStatus;

    /**
     * 订阅公司编码
     */
    private String subsCompanyCode;

    /**
     * 订阅人员编号
     */
    private String subsUserId;

    /**
     * 订阅人名称
     */
    private String subsUserName;

    /**
     * 订阅时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private LocalDateTime subsCtime;

    /**
     * 修改时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private LocalDateTime subsMtime;
}

//    create table ocp_model_subs
//        (
//                obj_id            varchar(42) not null
//        constraint ocp_model_subs_pkey
//        primary key,
//        model_code        varchar(42) not null,
//        subs_status       smallint,
//        subs_company_code varchar(42) not null,
//        subs_user_id      varchar(42),
//        subs_user_name    varchar(64),
//        subs_ctime        timestamp(6),
//        subs_mtime        timestamp(6)
//        );
//
//        comment on table ocp_model_subs is '模型订阅表';
//        comment on column ocp_model_subs.obj_id is '主键是';
//        comment on column ocp_model_subs.model_code is '模型code是';
//        comment on column ocp_model_subs.subs_status is '订阅状态0:订阅,1:取消订阅';
//        comment on column ocp_model_subs.subs_company_code is '订阅公司code';
//        comment on column ocp_model_subs.subs_user_id is '订阅人员id';
//        comment on column ocp_model_subs.subs_user_name is '订阅人';
//        comment on column ocp_model_subs.subs_ctime is '订阅时间';
//        comment on column ocp_model_subs.subs_mtime is '修改时间';
//        alter table ocp_model_subs
//        owner to postgres;