package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.mapper.ApiBasicManagementMapper;
import com.pms.ocp.mapper.OcpApiExtentMapper;
import com.pms.ocp.mapper.OcpApiSubsMapper;
import com.pms.ocp.model.entity.OcpApiBase;
import com.pms.ocp.model.entity.OcpApiExtent;
import com.pms.ocp.model.entity.OcpApiSubs;
import com.pms.ocp.model.vo.OcpApiBaseVo;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.ApiBasicManagementService;
import com.pms.ocp.service.OcpApiExtentService;
import com.pms.ocp.service.OcpApiSubsService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.time.LocalDateTime;

import java.util.Arrays;

import java.util.List;

@Service
public class ApiBasicManagementServiceImpl extends ServiceImpl<ApiBasicManagementMapper, OcpApiBase>
        implements ApiBasicManagementService {
    @Autowired
    private ApiBasicManagementMapper apiBasicManagementMapper;
    @Autowired
    private OcpApiSubsMapper ocpApiSubsMapper;
    @Autowired
    private OcpApiExtentService ocpApiExtentService;
    @Autowired
    private OcpApiExtentMapper ocpApiExtentMapper;

    /**
     * 导出查询
     *
     * @param apiCodes
     * @return
     */
    public List<OcpApiBaseVo> selectApiExport(String apiCodes) {
        String[] split = apiCodes.split(",");
        List<String> list = Arrays.asList(split);
        return apiBasicManagementMapper.selectApiExport(list);

    }

    /**
     * 服务注册
     *
     * @param ocpApiBase
     */
    public void addOcpApiBase(OcpApiBase ocpApiBase) {
        apiBasicManagementMapper.insert(ocpApiBase);
    }

    /**
     * 服务订阅
     *
     * @param apiCodes
     */
    public void apiLogin(String apiCodes) {
        String[] split = apiCodes.split(",");
        List<String> apiCode = Arrays.asList(split);
        for (String s : apiCode) {
            OcpApiSubs ocpApiSubs = new OcpApiSubs();
            ocpApiSubs.setApiCode(s);
            ocpApiSubs.setSubsLogApiCtime(Timestamp.valueOf(LocalDateTime.now()));
            ocpApiSubs.setSubsLogApiMtime(Timestamp.valueOf(LocalDateTime.now()));
            ocpApiSubs.setSubsLogApiUserId(null);
            ocpApiSubs.setSubsLogApiAtime(Timestamp.valueOf(LocalDateTime.now()));
            ocpApiSubs.setSubsCompanyCode(null);
            ocpApiSubsMapper.insert(ocpApiSubs);
        }
    }
    /**
     * 条件查询
     *
     * @param apiCode
     * @param keyword
     * @param apiUnit
     * @param startTime
     * @param endTime
     * @return
     */
    @Override
    public List<OcpApiBaseVo> queryOcpApiBaseDto(String apiCode, String keyword, String apiUnit, Timestamp startTime, Timestamp endTime, int pageSize, int pageNum) {
        pageSize = (pageSize - 1) * pageNum;
        return apiBasicManagementMapper.queryOcpApiBaseDto(keyword, apiUnit, startTime, endTime, apiCode, pageSize, pageNum);
    }


//    public OcpApiBaseDto queryOcpApiBaseDto(String apiCode, String keyword, String apiUnits, Timestamp startTime, Timestamp endTime, int pageSize, int pageNum) {
//        //String[] split = apiUnits.split(",");
////        List<String> list = Arrays.asList(split);
//        pageSize = (pageSize - 1) * pageNum;
//        OcpApiBaseDto ocpApiBaseDto = apiBasicManagementMapper.queryOcpApiBaseDto(keyword, apiUnits, startTime, endTime, apiCode, pageSize, pageNum);
//        return ocpApiBaseDto;
//    }

    /**
     * 导入添加到数据库
     *
     * @param personList
     */
    public void apiImport(List<OcpApiBaseVo> personList) {
        for (OcpApiBaseVo ocpApiBaseVo : personList) {
            String apiCode = ocpApiBaseVo.getApiCode();
            Timestamp apiCtime = ocpApiBaseVo.getApiCtime();
            String apiName = ocpApiBaseVo.getApiName();
            String apiUnit = ocpApiBaseVo.getApiUnit();
            String apiUrl = ocpApiBaseVo.getApiUrl();
            String apiState = ocpApiBaseVo.getApiState();
            String spaceName = ocpApiBaseVo.getSpaceName();
            String clusterName = ocpApiBaseVo.getClusterName();
            OcpApiBase ocpApiBase = new OcpApiBase();
            ocpApiBase.setApiCode(apiCode);
            ocpApiBase.setApiGroupCode("1");
            ocpApiBase.setApiCtime(apiCtime);
            ocpApiBase.setApiName(apiName);
            ocpApiBase.setApiUnit(apiUnit);
            ocpApiBase.setApiUrl(apiUrl);
            this.save(ocpApiBase);
            OcpApiExtent ocpApiExtent = new OcpApiExtent();
            ocpApiExtent.setApiCode(apiCode);
            ocpApiExtent.setApiState(apiState);
            ocpApiExtent.setSpaceName(spaceName);
            ocpApiExtent.setClusterName(clusterName);
            ocpApiExtentService.save(ocpApiExtent);

        }
    }

    /**
     * 服务发布
     *
     * @param apiCodes
     */
    public ResponseVO apiIssue(String apiCodes) {
        String[] split = apiCodes.split(",");
        List<String> list = Arrays.asList(split);
        LambdaQueryWrapper<OcpApiExtent> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(OcpApiExtent::getApiCode, list);
        List<OcpApiExtent> ocpApiExtents = ocpApiExtentMapper.selectList(lambdaQueryWrapper);
        for (OcpApiExtent ocpApiExtent : ocpApiExtents) {
            if (ocpApiExtent.getApiState().equals("1")) {
                return ResponseVO.error("已发布");
            } else {
                ocpApiExtent.setApiState("1");
                ocpApiExtentMapper.updateById(ocpApiExtent);
            }
        }
        return ResponseVO.ok();
    }

}
