package com.pms.ocp.common.constants;


import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

@Data
@ToString
@NoArgsConstructor
public class ResponseResult implements Response {

    //操作是否成功
    boolean success = SUCCESS;

    //操作代码
    int code = SUCCESS_CODE;

    //提示信息
    String message;

    public ResponseResult(Code Code){
        this.success = Code.success();
        this.code = Code.code();
        this.message = Code.message();
    }

    public ResponseResult(boolean success, int code, String msg){
        this.success = success;
        this.code = code;
        this.message = msg;
    }

    public static  ResponseResult SUCCESS(){
        return new ResponseResult(CommonCode.SUCCESS);
    }

    public static ResponseResult FAIL(){
        return new ResponseResult(CommonCode.FAIL);
    }

}
