package com.pms.ocp.common.exception;

import com.pms.ocp.common.utils.BeagleStringUtils;
import com.pms.ocp.model.vo.BaseResponse;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import com.pms.ocp.common.constants.CodeEnum;

import lombok.extern.slf4j.Slf4j;

/**
 * @author wuwanli
 * @version 1.0
 * @date 2021/8/5
 */
@Slf4j
@RestControllerAdvice
public class GlobalExceptionHandler {

	@ExceptionHandler(value = BeagleException.class)
	public BaseResponse beagleExceptionHandler(BeagleException beagleException) {
		log.error("GlobalExceptionHandler.beagleExceptionHandler", beagleException);
		BaseResponse baseResponse = new BaseResponse();
		if (BeagleStringUtils.isBlank(beagleException.getErrorCode())) {
			baseResponse.setResponseCode(CodeEnum.UNKNOWN);
		} else {
			baseResponse.setCode(beagleException.getErrorCode());
			baseResponse.setDesc(beagleException.getErrorMsg());
		}
		return baseResponse;
	}

	@ExceptionHandler(value = Exception.class)
	public BaseResponse exceptionHandler(Exception exception) {
		log.error("GlobalExceptionHandler.exceptionHandler", exception);
		return new BaseResponse(CodeEnum.UNKNOWN);
	}
}
