package com.pms.ocp.controller;



import com.pms.ocp.model.dto.OcpGroupBaseDto;
import com.pms.ocp.model.entity.OcpApiBase;
import com.pms.ocp.model.vo.ApiProvinceVo;
import com.pms.ocp.model.vo.OcpApiBaseVo;
import com.pms.ocp.model.vo.ResponseVO;

import com.pms.ocp.service.ApiBasicManagementService;
import com.pms.ocp.service.ApiDetailsService;
import com.pms.ocp.service.ApiProvinceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@RequestMapping("/apiProvince")
@RestController
@Api(tags = "服务省侧服务列表接口")
public class ApiProvinceController {
    @Autowired
    private ApiProvinceService apiProvinceService;
    @Autowired
    private ApiDetailsService apiDetailsService;
    @Autowired
    private ApiBasicManagementService apiBasicManagementService;

    @ApiOperation("服务省侧-添加")
    @PostMapping("/create")
    public ResponseVO createApiBase(@RequestBody ApiProvinceVo apiProvinceVo) {
        boolean isSuccess =  apiProvinceService.updateOrCreate(apiProvinceVo);
        if(isSuccess){
            return ResponseVO.ok();
        }else {
            return ResponseVO.error("添加失败");
        }
    }


    @ApiOperation("服务分类层级")
    @GetMapping("/apiBaseTreeOther")
    public ResponseVO<List<OcpGroupBaseDto>> apiBaseTreeOther(String apiGroupCompanyCode, String apiGroupCode, Integer apiGroupPromotionType, String apiCode) {
        List<OcpGroupBaseDto> apiTreeGroupDtos = apiBasicManagementService.apiBaseTreeOther(apiGroupCompanyCode, apiGroupCode, apiGroupPromotionType,apiCode);
        return ResponseVO.ok(apiTreeGroupDtos);
    }

    @ApiOperation("服务库服务详情-查询")
    @GetMapping("/query")
    public ResponseVO<OcpApiBaseVo> getApiDetails(String apiCode) {
        return apiDetailsService.getApiDetails(apiCode);
    }

}
