package com.pms.ocp.model.dto;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pms.ocp.model.entity.OcpApiBase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * @className: ApiManagementDto
 * @Description:
 * @author: pei-chen-xi
 * @DateTime: 2022/3/25 18:36
 */
@Data
@AllArgsConstructor
@ApiModel(value = "服务管理dto")
public class ApiManagementDto extends OcpApiBase implements Serializable {
    @ApiModelProperty(value = "服务名称")
    @Excel(name = "服务名称")
    private String apiName;
    @ApiModelProperty("服务代码")
    @Excel(name = "服务代码")
    private String apiCode;
    @ApiModelProperty(value = "服务类型")
    @Excel(name = "服务类型")
    private String apiGroupCode;
    @ApiModelProperty(value = "服务简述")
    @Excel(name = "服务简述")
    private String apiDescription;
    @ApiModelProperty(value = "服务所属公司")
    @Excel(name = "服务所属公司")
    private String ownerCompanyCode;
    @ApiModelProperty(value = "服务版本")
    @Excel(name = "服务版本")
    private String apiVersion;
    @ApiModelProperty(value = "服务状态0未发布1已发布")
    @Excel(name = "服务状态0未发布1已发布")
    private String apiState;
    @ApiModelProperty(value = "更新时间")
    @Excel(name = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Timestamp apiCtime;
    @ApiModelProperty(value = "修改时间")
    @Excel(name = "修改时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Timestamp apiMtime;



}
