package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.sql.Timestamp;

@Data
@Accessors(chain = true)
@ApiModel("服务管理")
public class PmsApiManagement {
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("主键ID")
    private String objId;

    @ApiModelProperty("服务代码")
    private String apiCode;

    @ApiModelProperty("服务接口中文名称")
    private String apiName;

    @ApiModelProperty("服务分类代码")
    private String apiGroupCode;

    @ApiModelProperty("推广类型0:统建；1:自建")
    private long apiPromotion;

    @ApiModelProperty("服务请求体")
    private String apiReq;

    @ApiModelProperty("服务返回体")
    private String apiResp;

    @ApiModelProperty("服务地址")
    private String apiUrl;

    @ApiModelProperty("服务创建时间")
    private Timestamp apiCtime;

    @ApiModelProperty("服务修改时间")
    private Timestamp apiMtime;

    @ApiModelProperty("创建者用户ID")
    private String apiUserId;

    @ApiModelProperty("建设单位")
    private String apiUnit;

    @ApiModelProperty("服务所属公司")
    private String ownerCompanyCode;

    @ApiModelProperty("是否删除0-否1-是")
    private long isDelete;

    @ApiModelProperty("所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区")
    private long apiZone;

    @ApiModelProperty("'所属层级 1:应用层;2:平台层;3:网络层;4:感知层;")
    private long apiLayer;

    @ApiModelProperty("服务版本（最新版本）")
    private String apiVersion;

    @ApiModelProperty("服务所属中心编码所属中心")
    private String apiCenterCode;

    @ApiModelProperty("服务简述")
    private String apiDescription;

    @ApiModelProperty("创建者姓名")
    private String apiUserName;

    //

    @ApiModelProperty("分类名称")
    private String apiGroupName;

    @ApiModelProperty("推广类型0统推，1自建")
    private long apiGroupPromotionType;

    @ApiModelProperty("分类所属公司")
    private String apiGroupCompanyCode;

    @ApiModelProperty("分类版本")
    private String apiGroupVersion;

    @ApiModelProperty("显示顺序")
    private long apiGroupOrderNo;

    @ApiModelProperty("提交人id")
    private String apiGroupUserId;

    @ApiModelProperty("提交人姓名")
    private String apiGroupUserName;

    @ApiModelProperty("创建时间")
    private Timestamp apiGroupCtime;

    @ApiModelProperty("修改时间")
    private Timestamp apiGroupMtime;

    @ApiModelProperty("上级code")
    private String apiGroupPcode;

    @ApiModelProperty("分层树层级 1中台层 2中心层 3 服务组层 4服务层 ")
    private String apiGroupLevel;


    //
    @ApiModelProperty("图标种类tenant:应用图标api:服务图标")
    private String iocnType;

    @ApiModelProperty("编码值")
    private String codeNo;

    @ApiModelProperty("应用调用的服务数量图标数据")
    private Object iocn;

    @ApiModelProperty("所属公司可能会根据公司分区")
    private String companyCode;

    @ApiModelProperty("当前页")
    private Integer pageNum;

    @ApiModelProperty("每页条数")
    private Integer pageSize;

    public String getObjId() {
        return objId;
    }

    public void setObjId(String objId) {
        this.objId = objId;
    }

    public String getApiCode() {
        return apiCode;
    }

    public void setApiCode(String apiCode) {
        this.apiCode = apiCode;
    }

    public String getApiName() {
        return apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getApiGroupCode() {
        return apiGroupCode;
    }

    public void setApiGroupCode(String apiGroupCode) {
        this.apiGroupCode = apiGroupCode;
    }

    public long getApiPromotion() {
        return apiPromotion;
    }

    public void setApiPromotion(long apiPromotion) {
        this.apiPromotion = apiPromotion;
    }

    public String getApiReq() {
        return apiReq;
    }

    public void setApiReq(String apiReq) {
        this.apiReq = apiReq;
    }

    public String getApiResp() {
        return apiResp;
    }

    public void setApiResp(String apiResp) {
        this.apiResp = apiResp;
    }

    public String getApiUrl() {
        return apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public Timestamp getApiCtime() {
        return apiCtime;
    }

    public void setApiCtime(Timestamp apiCtime) {
        this.apiCtime = apiCtime;
    }

    public Timestamp getApiMtime() {
        return apiMtime;
    }

    public void setApiMtime(Timestamp apiMtime) {
        this.apiMtime = apiMtime;
    }

    public String getApiUserId() {
        return apiUserId;
    }

    public void setApiUserId(String apiUserId) {
        this.apiUserId = apiUserId;
    }

    public String getApiUnit() {
        return apiUnit;
    }

    public void setApiUnit(String apiUnit) {
        this.apiUnit = apiUnit;
    }

    public String getOwnerCompanyCode() {
        return ownerCompanyCode;
    }

    public void setOwnerCompanyCode(String ownerCompanyCode) {
        this.ownerCompanyCode = ownerCompanyCode;
    }

    public long getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(long isDelete) {
        this.isDelete = isDelete;
    }

    public long getApiZone() {
        return apiZone;
    }

    public void setApiZone(long apiZone) {
        this.apiZone = apiZone;
    }

    public long getApiLayer() {
        return apiLayer;
    }

    public void setApiLayer(long apiLayer) {
        this.apiLayer = apiLayer;
    }

    public String getApiVersion() {
        return apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getApiCenterCode() {
        return apiCenterCode;
    }

    public void setApiCenterCode(String apiCenterCode) {
        this.apiCenterCode = apiCenterCode;
    }

    public String getApiDescription() {
        return apiDescription;
    }

    public void setApiDescription(String apiDescription) {
        this.apiDescription = apiDescription;
    }

    public String getApiUserName() {
        return apiUserName;
    }

    public void setApiUserName(String apiUserName) {
        this.apiUserName = apiUserName;
    }

    public String getApiGroupName() {
        return apiGroupName;
    }

    public void setApiGroupName(String apiGroupName) {
        this.apiGroupName = apiGroupName;
    }

    public long getApiGroupPromotionType() {
        return apiGroupPromotionType;
    }

    public void setApiGroupPromotionType(long apiGroupPromotionType) {
        this.apiGroupPromotionType = apiGroupPromotionType;
    }

    public String getApiGroupCompanyCode() {
        return apiGroupCompanyCode;
    }

    public void setApiGroupCompanyCode(String apiGroupCompanyCode) {
        this.apiGroupCompanyCode = apiGroupCompanyCode;
    }

    public String getApiGroupVersion() {
        return apiGroupVersion;
    }

    public void setApiGroupVersion(String apiGroupVersion) {
        this.apiGroupVersion = apiGroupVersion;
    }

    public long getApiGroupOrderNo() {
        return apiGroupOrderNo;
    }

    public void setApiGroupOrderNo(long apiGroupOrderNo) {
        this.apiGroupOrderNo = apiGroupOrderNo;
    }

    public String getApiGroupUserId() {
        return apiGroupUserId;
    }

    public void setApiGroupUserId(String apiGroupUserId) {
        this.apiGroupUserId = apiGroupUserId;
    }

    public String getApiGroupUserName() {
        return apiGroupUserName;
    }

    public void setApiGroupUserName(String apiGroupUserName) {
        this.apiGroupUserName = apiGroupUserName;
    }

    public Timestamp getApiGroupCtime() {
        return apiGroupCtime;
    }

    public void setApiGroupCtime(Timestamp apiGroupCtime) {
        this.apiGroupCtime = apiGroupCtime;
    }

    public Timestamp getApiGroupMtime() {
        return apiGroupMtime;
    }

    public void setApiGroupMtime(Timestamp apiGroupMtime) {
        this.apiGroupMtime = apiGroupMtime;
    }

    public String getApiGroupPcode() {
        return apiGroupPcode;
    }

    public void setApiGroupPcode(String apiGroupPcode) {
        this.apiGroupPcode = apiGroupPcode;
    }

    public String getApiGroupLevel() {
        return apiGroupLevel;
    }

    public void setApiGroupLevel(String apiGroupLevel) {
        this.apiGroupLevel = apiGroupLevel;
    }

    public String getIocnType() {
        return iocnType;
    }

    public void setIocnType(String iocnType) {
        this.iocnType = iocnType;
    }

    public String getCodeNo() {
        return codeNo;
    }

    public void setCodeNo(String codeNo) {
        this.codeNo = codeNo;
    }

    public Object getIocn() {
        return iocn;
    }

    public void setIocn(Object iocn) {
        this.iocn = iocn;
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}
