package com.pms.ocp.model.entity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * 应用事记表
 * @TableName ocp_tenant_audit
 */
@Data
@Accessors(chain = true)
@ApiModel("应用事记表1")
public class PmsTenantAudit implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("主键ID")
    @Excel(name = "主键ID",orderNum = "1")
    private String objId;

    /**
     * 应用code
     */
    @ApiModelProperty("应用code")
    @Excel(name = "应用code",orderNum = "2")
    private String tenantCode;

    /**
     * 操作状态0:新增,1:迭代；2，下线
     */
    @ApiModelProperty("操作状态0:新增,1:迭代；2，下线")
    @Excel(name = "操作状态0:新增,1:迭代；2，下线",orderNum = "3")
    private Short operStatus;

    /**
     * 类型0:人工操作,1:流程管控,3:总部下发
     */
    @ApiModelProperty("类型0:人工操作,1:流程管控,3:总部下发")
    @Excel(name = "类型0:人工操作,1:流程管控,3:总部下发",orderNum = "4")
    private Short auditType;

    /**
     * 备注简述
     */
    @ApiModelProperty("备注简述")
    @Excel(name = "备注简述",orderNum = "5")
    private String auditMessage;

    /**
     * 应用事记内容
     */
    @ApiModelProperty("应用事记内容")
    @Excel(name = "应用事记内容",orderNum = "6")
    private String auditJson;

    /**
     * 提交人id
     */
    @ApiModelProperty("提交人id")
    @Excel(name = "提交人id",orderNum = "7")
    private String auditUserId;

    /**
     * 提交人姓名
     */
    @ApiModelProperty("提交人姓名")
    @Excel(name = "提交人姓名",orderNum = "8")
    private String auditUserName;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    @Excel(name = "创建时间",orderNum = "9")
    private Timestamp auditCtime;

    /**
     * 应用版本(当前版本)
     */
    @ApiModelProperty(" 应用版本(当前版本")
    @Excel(name = " 应用版本(当前版本",orderNum = "10")
    private String applyVersion;

    /**
     * 上一版本
     */
    @ApiModelProperty("上一版本")
    @Excel(name = " 上一版本",orderNum = "11")
    private String perTenantVersion;

    private static final long serialVersionUID = 1L;






    /**
     * 应用名称
     */
    @ApiModelProperty("应用名称")
    private String tenantName;




    @ApiModelProperty("应用分类代码")
    private String tenantGroupCode;


    @ApiModelProperty("应用ip")
    private String tenantIp;


    @ApiModelProperty("应用url")
    private String tenantUrl;


    @ApiModelProperty("所属专业")
    private String professionalKind;

    @ApiModelProperty("创建者用户ID")
    private String tenantUserId;


    @ApiModelProperty("排序")
    private Integer tenantOrderNo;

    @ApiModelProperty("创建时间")
    private Timestamp tenantCtime;


    @ApiModelProperty("最后更新时间")
    private Timestamp tenantMtime;



    @ApiModelProperty("部署名称")
    private String deploymentName;


    @ApiModelProperty("描述")
    private String tenantDescription;


    @ApiModelProperty("应用状态0:设计态；1:运行态")
    private Short tenantState;

    @ApiModelProperty("推广类型0:统建；1:自建")
    private long tenantPromotion;

    @ApiModelProperty("建设单位")
    private String tenantUnit;


    @ApiModelProperty("所属公司编码")
    private String ownerCompanyCode;


    @ApiModelProperty("所属公司名称")
    private String ownerCompanyName;


    @ApiModelProperty("应用路径")
    private String tenantFullPath;


    @ApiModelProperty("是否删除0:否;1:是")
    private Short isDelete;


    @ApiModelProperty("所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区")
    private Short tenantZone;


    @ApiModelProperty("所属层级 1:应用层;2:平台层;3:网络层;4:感知层;")
    private Short tenantLayer;


    @ApiModelProperty("应用版本（当前版本）")
    private String tenantVersion;



//    public String getObjId() {
//        return objId;
//    }
//
//    public void setObjId(String objId) {
//        this.objId = objId;
//    }
//
//    public String getTenantCode() {
//        return tenantCode;
//    }
//
//    public void setTenantCode(String tenantCode) {
//        this.tenantCode = tenantCode;
//    }
//
//    public Short getOperStatus() {
//        return operStatus;
//    }
//
//    public void setOperStatus(Short operStatus) {
//        this.operStatus = operStatus;
//    }
//
//    public Short getAuditType() {
//        return auditType;
//    }
//
//    public void setAuditType(Short auditType) {
//        this.auditType = auditType;
//    }
//
//    public String getAuditMessage() {
//        return auditMessage;
//    }
//
//    public void setAuditMessage(String auditMessage) {
//        this.auditMessage = auditMessage;
//    }
//
//    public String getAuditJson() {
//        return auditJson;
//    }
//
//    public void setAuditJson(String auditJson) {
//        this.auditJson = auditJson;
//    }
//
//    public String getAuditUserId() {
//        return auditUserId;
//    }
//
//    public void setAuditUserId(String auditUserId) {
//        this.auditUserId = auditUserId;
//    }
//
//    public String getAuditUserName() {
//        return auditUserName;
//    }
//
//    public void setAuditUserName(String auditUserName) {
//        this.auditUserName = auditUserName;
//    }
//
//    public Date getAuditCtime() {
//        return auditCtime;
//    }
//
//    public void setAuditCtime(Timestamp auditCtime) {
//        this.auditCtime = auditCtime;
//    }
//
//    public void setApplyVersion(String applyVersion) {
//        this.applyVersion = applyVersion;
//    }
//
//    public String getPerTenantVersion() {
//        return perTenantVersion;
//    }
//
//    public void setPerTenantVersion(String perTenantVersion) {
//        this.perTenantVersion = perTenantVersion;
//    }
//
//    public static long getSerialVersionUID() {
//        return serialVersionUID;
//    }
//
//    public String getApiCode() {
//        return apiCode;
//    }
//
//    public void setApiCode(String apiCode) {
//        this.apiCode = apiCode;
//    }
//
//    public String getApiDepCompanyCode() {
//        return apiDepCompanyCode;
//    }
//
//    public void setApiDepCompanyCode(String apiDepCompanyCode) {
//        this.apiDepCompanyCode = apiDepCompanyCode;
//    }
//
//    public String getTenantDepCompanyCode() {
//        return tenantDepCompanyCode;
//    }
//
//    public void setTenantDepCompanyCode(String tenantDepCompanyCode) {
//        this.tenantDepCompanyCode = tenantDepCompanyCode;
//    }
//
//    public Timestamp getApiTenantRelCtime() {
//        return apiTenantRelCtime;
//    }
//
//    public void setApiTenantRelCtime(Timestamp apiTenantRelCtime) {
//        this.apiTenantRelCtime = apiTenantRelCtime;
//    }
//
//    public Timestamp getApiTenantRelMtime() {
//        return apiTenantRelMtime;
//    }
//
//    public void setApiTenantRelMtime(Timestamp apiTenantRelMtime) {
//        this.apiTenantRelMtime = apiTenantRelMtime;
//    }
//
//    public String getApiTenantRelUserId() {
//        return apiTenantRelUserId;
//    }
//
//    public void setApiTenantRelUserId(String apiTenantRelUserId) {
//        this.apiTenantRelUserId = apiTenantRelUserId;
//    }
//
//    public String getApiTenantRelUserName() {
//        return apiTenantRelUserName;
//    }
//
//    public void setApiTenantRelUserName(String apiTenantRelUserName) {
//        this.apiTenantRelUserName = apiTenantRelUserName;
//    }
//
//    public long getIsDelete() {
//        return isDelete;
//    }
//
//    public void setIsDelete(long isDelete) {
//        this.isDelete = isDelete;
//    }
//
//    public String getApiName() {
//        return apiName;
//    }
//
//    public void setApiName(String apiName) {
//        this.apiName = apiName;
//    }
//
//    public String getApiGroupCode() {
//        return apiGroupCode;
//    }
//
//    public void setApiGroupCode(String apiGroupCode) {
//        this.apiGroupCode = apiGroupCode;
//    }
//
//    public long getApiPromotion() {
//        return apiPromotion;
//    }
//
//    public void setApiPromotion(long apiPromotion) {
//        this.apiPromotion = apiPromotion;
//    }
//
//    public String getApiReq() {
//        return apiReq;
//    }
//
//    public void setApiReq(String apiReq) {
//        this.apiReq = apiReq;
//    }
//
//    public String getApiResp() {
//        return apiResp;
//    }
//
//    public void setApiResp(String apiResp) {
//        this.apiResp = apiResp;
//    }
//
//    public String getApiUrl() {
//        return apiUrl;
//    }
//
//    public void setApiUrl(String apiUrl) {
//        this.apiUrl = apiUrl;
//    }
//
//    public Timestamp getApiCtime() {
//        return apiCtime;
//    }
//
//    public void setApiCtime(Timestamp apiCtime) {
//        this.apiCtime = apiCtime;
//    }
//
//    public Timestamp getApiMtime() {
//        return apiMtime;
//    }
//
//    public void setApiMtime(Timestamp apiMtime) {
//        this.apiMtime = apiMtime;
//    }
//
//    public String getApiUserId() {
//        return apiUserId;
//    }
//
//    public void setApiUserId(String apiUserId) {
//        this.apiUserId = apiUserId;
//    }
//
//    public String getApiUnit() {
//        return apiUnit;
//    }
//
//    public void setApiUnit(String apiUnit) {
//        this.apiUnit = apiUnit;
//    }
//
//    public String getOwnerCompanyCode() {
//        return ownerCompanyCode;
//    }
//
//    public void setOwnerCompanyCode(String ownerCompanyCode) {
//        this.ownerCompanyCode = ownerCompanyCode;
//    }
//
//    public String getOwnerCompanyName() {
//        return ownerCompanyName;
//    }
//
//    public void setOwnerCompanyName(String ownerCompanyName) {
//        this.ownerCompanyName = ownerCompanyName;
//    }
//
//    public long getApiZone() {
//        return apiZone;
//    }
//
//    public void setApiZone(long apiZone) {
//        this.apiZone = apiZone;
//    }
//
//    public long getApiLayer() {
//        return apiLayer;
//    }
//
//    public void setApiLayer(long apiLayer) {
//        this.apiLayer = apiLayer;
//    }
//
//    public long getApiVersion() {
//        return apiVersion;
//    }
//
//    public void setApiVersion(long apiVersion) {
//        this.apiVersion = apiVersion;
//    }

//    @Override
//    public boolean equals(Object that) {
//        if (this == that) {
//            return true;
//        }
//        if (that == null) {
//            return false;
//        }
//        if (getClass() != that.getClass()) {
//            return false;
//        }
//        OcpTenantAudit other = (OcpTenantAudit) that;
//        return (this.getObjId() == null ? other.getObjId() == null : this.getObjId().equals(other.getObjId()))
//                && (this.getTenantCode() == null ? other.getTenantCode() == null : this.getTenantCode().equals(other.getTenantCode()))
//                && (this.getOperStatus() == null ? other.getOperStatus() == null : this.getOperStatus().equals(other.getOperStatus()))
//                && (this.getAuditType() == null ? other.getAuditType() == null : this.getAuditType().equals(other.getAuditType()))
//                && (this.getAuditMessage() == null ? other.getAuditMessage() == null : this.getAuditMessage().equals(other.getAuditMessage()))
//                && (this.getAuditJson() == null ? other.getAuditJson() == null : this.getAuditJson().equals(other.getAuditJson()))
//                && (this.getAuditUserId() == null ? other.getAuditUserId() == null : this.getAuditUserId().equals(other.getAuditUserId()))
//                && (this.getAuditUserName() == null ? other.getAuditUserName() == null : this.getAuditUserName().equals(other.getAuditUserName()))
//                && (this.getAuditCtime() == null ? other.getAuditCtime() == null : this.getAuditCtime().equals(other.getAuditCtime()))
//                && (this.getApplyVersion() == null ? other.getApplyVersion() == null : this.getApplyVersion().equals(other.getApplyVersion()))
//                && (this.getPerTenantVersion() == null ? other.getPerTenantVersion() == null : this.getPerTenantVersion().equals(other.getPerTenantVersion()));
//    }
//
//    @Override
//    public int hashCode() {
//        final int prime = 31;
//        int result = 1;
//        result = prime * result + ((getObjId() == null) ? 0 : getObjId().hashCode());
//        result = prime * result + ((getTenantCode() == null) ? 0 : getTenantCode().hashCode());
//        result = prime * result + ((getOperStatus() == null) ? 0 : getOperStatus().hashCode());
//        result = prime * result + ((getAuditType() == null) ? 0 : getAuditType().hashCode());
//        result = prime * result + ((getAuditMessage() == null) ? 0 : getAuditMessage().hashCode());
//        result = prime * result + ((getAuditJson() == null) ? 0 : getAuditJson().hashCode());
//        result = prime * result + ((getAuditUserId() == null) ? 0 : getAuditUserId().hashCode());
//        result = prime * result + ((getAuditUserName() == null) ? 0 : getAuditUserName().hashCode());
//        result = prime * result + ((getAuditCtime() == null) ? 0 : getAuditCtime().hashCode());
//        result = prime * result + ((getApplyVersion() == null) ? 0 : getApplyVersion().hashCode());
//        result = prime * result + ((getPerTenantVersion() == null) ? 0 : getPerTenantVersion().hashCode());
//        return result;
//    }
//
//    @Override
//    public String toString() {
//        StringBuilder sb = new StringBuilder();
//        sb.append(getClass().getSimpleName());
//        sb.append(" [");
//        sb.append("Hash = ").append(hashCode());
//        sb.append(", objId=").append(objId);
//        sb.append(", tenantCode=").append(tenantCode);
//        sb.append(", operStatus=").append(operStatus);
//        sb.append(", auditType=").append(auditType);
//        sb.append(", auditMessage=").append(auditMessage);
//        sb.append(", auditJson=").append(auditJson);
//        sb.append(", auditUserId=").append(auditUserId);
//        sb.append(", auditUserName=").append(auditUserName);
//        sb.append(", auditCtime=").append(auditCtime);
//        sb.append(", applyVersion=").append(applyVersion);
//        sb.append(", perTenantVersion=").append(perTenantVersion);
//        sb.append(", serialVersionUID=").append(serialVersionUID);
//        sb.append("]");
//        return sb.toString();
//    }
}