package com.pms.ocp.model.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.pms.ocp.model.entity.OcpApiParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.factory.annotation.Value;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author guofanfan
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "服务列表信息vo")
public class OcpApiBaseVo implements Serializable {
    @ApiModelProperty(value = "序号")
    @Excel(name = "序号")
    private String objId;
    @ApiModelProperty(value = "服务编码")
    @Excel(name = "服务编码")
    private String apiCode;
    @ApiModelProperty(value = "服务中文名称")
    @Excel(name = "服务中文名称")
    private String apiName;
    @ApiModelProperty(value = "所属集群")
    @Excel(name = "所属集群")
    private String clusterName;
    @ApiModelProperty(value = "所属命名空间")
    @Excel(name = "所属命名空间")
    private String spaceName;
    @ApiModelProperty(value = "接口URL")
    @Excel(name = "接口URL")
    private String apiUrl;
    @ApiModelProperty(value = "状态")
    @Excel(name = "状态")
    private String apiState;
    @ApiModelProperty(value = "注册时间")
    @Excel(name = "注册时间")
    private Timestamp apiCtime;
    @ApiModelProperty(value = "建设单位")
    @Excel(name = "建设单位")
    private String apiUnit;
    @ApiModelProperty(value = "查询开始时间")
    private String startTime;
    @ApiModelProperty(value = "查询结束时间")
    private String endTime;
    @ApiModelProperty(value = "出参入参")
    private List<OcpApiParam> apiParams;
    @ApiModelProperty(value = "出参集合")
    private List<OcpApiParam> apiOutParams;
    @ApiModelProperty(value = "入参集合")
    private List<OcpApiParam> apiINParams;
    @ApiModelProperty("服务分类代码")
    private String apiGroupCode;

    @ApiModelProperty("推广类型0:统建；1:自建")
    private long apiPromotion;

    @ApiModelProperty("服务请求体")
    private String apiReq;

    @ApiModelProperty("服务返回体")
    private String apiResp;


    @ApiModelProperty("服务修改时间")
    private Timestamp apiMtime;

    @ApiModelProperty("创建者用户ID")
    private String apiUserId;

    @ApiModelProperty("服务所属公司")
    private String ownerCompanyCode;

    @ApiModelProperty("是否删除0-否1-是")
    private long isDelete;

    @ApiModelProperty("所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区")
    private long apiZone;

    @ApiModelProperty("'所属层级 1:应用层;2:平台层;3:网络层;4:感知层;")
    private long apiLayer;

    @ApiModelProperty("服务版本（最新版本）")
    private String apiVersion;

    @ApiModelProperty("服务所属中心编码所属中心")
    private String apiCenterCode;

    @ApiModelProperty("服务简述")
    private String apiDescription;

    @ApiModelProperty("创建者姓名")
    private String apiUserName;

    //

    @ApiModelProperty("分类名称")
    private String apiGroupName;

    @ApiModelProperty("推广类型0统推，1自建")
    private Integer apiGroupPromotionType;

    @ApiModelProperty("分类所属公司")
    private String apiGroupCompanyCode;

    @ApiModelProperty("分类版本")
    private String apiGroupVersion;

    @ApiModelProperty("显示顺序")
    private long apiGroupOrderNo;

    @ApiModelProperty("提交人id")
    private String apiGroupUserId;

    @ApiModelProperty("提交人姓名")
    private String apiGroupUserName;

    @ApiModelProperty("创建时间")
    private Timestamp apiGroupCtime;

    @ApiModelProperty("修改时间")
    private Timestamp apiGroupMtime;

    @ApiModelProperty("上级code")
    private String apiGroupPcode;

    @ApiModelProperty("分层树层级 1中台层 2中心层 3 服务组层 4服务层 ")
    private String apiGroupLevel;

    @ApiModelProperty("所属专业; ts:输电,t:变电, dc:直流，ds配电，tc:技术，pl计划 im综合")
    private String professionalKind;
    //
    @ApiModelProperty("图标种类tenant:应用图标api:服务图标")
    private String iocnType;

    @ApiModelProperty("编码值")
    private String codeNo;

    @ApiModelProperty("应用调用的服务数量图标数据")
    private Object iocn;

    @ApiModelProperty("所属公司可能会根据公司分区")
    private String companyCode;

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getProfessionalKind() {
        return professionalKind;
    }

    public void setProfessionalKind(String professionalKind) {
        this.professionalKind = professionalKind;
    }

    public String getApiGroupCode() {
        return apiGroupCode;
    }

    public List<OcpApiParam> getApiOutParams() {
        return apiOutParams;
    }

    public void setApiOutParams(List<OcpApiParam> apiOutParams) {
        this.apiOutParams = apiOutParams;
    }

    public List<OcpApiParam> getApiINParams() {
        return apiINParams;
    }

    public void setApiINParams(List<OcpApiParam> apiINParams) {
        this.apiINParams = apiINParams;
    }

    public void setApiGroupCode(String apiGroupCode) {
        this.apiGroupCode = apiGroupCode;
    }

    public long getApiPromotion() {
        return apiPromotion;
    }

    public void setApiPromotion(long apiPromotion) {
        this.apiPromotion = apiPromotion;
    }

    public String getApiReq() {
        return apiReq;
    }

    public void setApiReq(String apiReq) {
        this.apiReq = apiReq;
    }

    public String getApiResp() {
        return apiResp;
    }

    public void setApiResp(String apiResp) {
        this.apiResp = apiResp;
    }

    public Timestamp getApiMtime() {
        return apiMtime;
    }

    public void setApiMtime(Timestamp apiMtime) {
        this.apiMtime = apiMtime;
    }

    public String getApiUserId() {
        return apiUserId;
    }

    public void setApiUserId(String apiUserId) {
        this.apiUserId = apiUserId;
    }

    public String getOwnerCompanyCode() {
        return ownerCompanyCode;
    }

    public void setOwnerCompanyCode(String ownerCompanyCode) {
        this.ownerCompanyCode = ownerCompanyCode;
    }

    public long getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(long isDelete) {
        this.isDelete = isDelete;
    }

    public long getApiZone() {
        return apiZone;
    }

    public void setApiZone(long apiZone) {
        this.apiZone = apiZone;
    }

    public long getApiLayer() {
        return apiLayer;
    }

    public void setApiLayer(long apiLayer) {
        this.apiLayer = apiLayer;
    }

    public String getApiVersion() {
        return apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getApiCenterCode() {
        return apiCenterCode;
    }

    public void setApiCenterCode(String apiCenterCode) {
        this.apiCenterCode = apiCenterCode;
    }

    public String getApiDescription() {
        return apiDescription;
    }

    public void setApiDescription(String apiDescription) {
        this.apiDescription = apiDescription;
    }

    public String getApiUserName() {
        return apiUserName;
    }

    public void setApiUserName(String apiUserName) {
        this.apiUserName = apiUserName;
    }

    public String getApiGroupName() {
        return apiGroupName;
    }

    public void setApiGroupName(String apiGroupName) {
        this.apiGroupName = apiGroupName;
    }

    public Integer getApiGroupPromotionType() {
        return apiGroupPromotionType;
    }

    public void setApiGroupPromotionType(Integer apiGroupPromotionType) {
        this.apiGroupPromotionType = apiGroupPromotionType;
    }

    public String getApiGroupCompanyCode() {
        return apiGroupCompanyCode;
    }

    public void setApiGroupCompanyCode(String apiGroupCompanyCode) {
        this.apiGroupCompanyCode = apiGroupCompanyCode;
    }

    public String getApiGroupVersion() {
        return apiGroupVersion;
    }

    public void setApiGroupVersion(String apiGroupVersion) {
        this.apiGroupVersion = apiGroupVersion;
    }

    public long getApiGroupOrderNo() {
        return apiGroupOrderNo;
    }

    public void setApiGroupOrderNo(long apiGroupOrderNo) {
        this.apiGroupOrderNo = apiGroupOrderNo;
    }

    public String getApiGroupUserId() {
        return apiGroupUserId;
    }

    public void setApiGroupUserId(String apiGroupUserId) {
        this.apiGroupUserId = apiGroupUserId;
    }

    public String getApiGroupUserName() {
        return apiGroupUserName;
    }

    public void setApiGroupUserName(String apiGroupUserName) {
        this.apiGroupUserName = apiGroupUserName;
    }

    public Timestamp getApiGroupCtime() {
        return apiGroupCtime;
    }

    public void setApiGroupCtime(Timestamp apiGroupCtime) {
        this.apiGroupCtime = apiGroupCtime;
    }

    public Timestamp getApiGroupMtime() {
        return apiGroupMtime;
    }

    public void setApiGroupMtime(Timestamp apiGroupMtime) {
        this.apiGroupMtime = apiGroupMtime;
    }

    public String getApiGroupPcode() {
        return apiGroupPcode;
    }

    public void setApiGroupPcode(String apiGroupPcode) {
        this.apiGroupPcode = apiGroupPcode;
    }

    public String getApiGroupLevel() {
        return apiGroupLevel;
    }

    public void setApiGroupLevel(String apiGroupLevel) {
        this.apiGroupLevel = apiGroupLevel;
    }

    public String getIocnType() {
        return iocnType;
    }

    public void setIocnType(String iocnType) {
        this.iocnType = iocnType;
    }

    public String getCodeNo() {
        return codeNo;
    }

    public void setCodeNo(String codeNo) {
        this.codeNo = codeNo;
    }

    public Object getIocn() {
        return iocn;
    }

    public void setIocn(Object iocn) {
        this.iocn = iocn;
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public String getObjId() {
        return objId;
    }

    public void setObjId(String objId) {
        this.objId = objId;
    }

    public String getApiCode() {
        return apiCode;
    }

    public void setApiCode(String apiCode) {
        this.apiCode = apiCode;
    }

    public String getApiName() {
        return apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getClusterName() {
        return clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getSpaceName() {
        return spaceName;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public String getApiUrl() {
        return apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getApiState() {
        return apiState;
    }

    public void setApiState(String apiState) {
        this.apiState = apiState;
    }

    public Timestamp getApiCtime() {
        return apiCtime;
    }

    public void setApiCtime(Timestamp apiCtime) {
        this.apiCtime = apiCtime;
    }

    public String getApiUnit() {
        return apiUnit;
    }

    public void setApiUnit(String apiUnit) {
        this.apiUnit = apiUnit;
    }

    public List<OcpApiParam> getApiParams() {
        return apiParams;
    }

    public void setApiParams(List<OcpApiParam> apiParams) {
        this.apiParams = apiParams;
    }
}

