package com.pms.ocp.model.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.sql.Timestamp;
import java.util.List;

@Data
@Accessors(chain = true)
@TableName("ocp_api_group")
@ApiModel("服务分类表")
public class OcpApiGroupVo {

    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("主键ID")
    private String objId;

    @ApiModelProperty("分类编码")
    private String apiGroupCode;

    @ApiModelProperty("分类名称")
    private String apiGroupName;

    @ApiModelProperty("推广类型0统推，1自建")
    private long apiGroupPromotionType;

    @ApiModelProperty("分类所属公司")
    private String apiGroupCompanyCode;

    @ApiModelProperty("分类版本")
    private String apiGroupVersion;

    @ApiModelProperty("显示顺序")
    private long apiGroupOrderNo;

    @ApiModelProperty("提交人id")
    private String apiGroupUserId;

    @ApiModelProperty("提交人姓名")
    private String apiGroupUserName;

    @ApiModelProperty("创建时间")
    private Timestamp apiGroupCtime;

    @ApiModelProperty("修改时间")
    private Timestamp apiGroupMtime;

    @ApiModelProperty("上级code")
    private String apiGroupPcode;


    @ApiModelProperty("是否删除0-否1-是")
    private long isDelete;

    @ApiModelProperty("分层树层级 1中台层 2中心层 3 服务组层 4服务层 ")
    private String apiGroupLevel;


    @ApiModelProperty("上级分类名称")
    @TableField(exist = false)
    private String classIfy;

    @TableField(exist = false)
    @ApiModelProperty(value = "子类集合")
    private List<OcpApiGroupVo> childrenList;


}