package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.pms.ocp.mapper.ApiDetailsMapper;
import com.pms.ocp.mapper.ApiParamMapper;
import com.pms.ocp.model.dto.ApiBaseDto;
import com.pms.ocp.model.entity.*;
import com.pms.ocp.model.vo.OcpApiBaseVo;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.ApiDetailsService;
import com.pms.ocp.service.OcpApiExtentService;
import com.pms.ocp.service.OcpApiSubsService;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Service
public class ApiDetailsServiceImpl implements ApiDetailsService {


    @Autowired
    private ApiDetailsMapper apiDetailsMapper;
    @Autowired
    private ApiParamMapper apiParamMapper;

    @Override
    public ResponseVO<OcpApiBaseVo> getApiDetails(String apiCode) {
        //根据Apicode获取当前服务数据
        OcpApiBaseVo ocpApiBase = apiDetailsMapper.selectByCode(apiCode);
        //查询请求字段表
        QueryWrapper<OcpApiParam> wrapper = new QueryWrapper<>();
        wrapper.lambda().eq(OcpApiParam::getApiCode, apiCode);
        wrapper.lambda().eq(OcpApiParam::getApiParamClassification, "out");
        List<OcpApiParam> ocpApiOutParams = apiParamMapper.selectList(wrapper);
        QueryWrapper<OcpApiParam> wrappers = new QueryWrapper<>();
        wrappers.lambda().eq(OcpApiParam::getApiCode, apiCode);
        wrappers.lambda().eq(OcpApiParam::getApiParamClassification, "in");
        List<OcpApiParam> ocpApiInParams = apiParamMapper.selectList(wrappers);
        ocpApiBase.setApiOutParams(ocpApiOutParams);
        ocpApiBase.setApiINParams(ocpApiInParams);
        return ResponseVO.ok(ocpApiBase);
    }


}
