package com.pms.ocp.service.impl;

import com.github.pagehelper.util.StringUtil;
import com.pms.ocp.common.utils.RandomStringUtils;
import com.pms.ocp.mapper.ApiDetailsMapper;
import com.pms.ocp.mapper.ApiParamMapper;
import com.pms.ocp.mapper.ApiProvinceMapper;
import com.pms.ocp.mapper.AppRegisterMapper;
import com.pms.ocp.model.dto.ImgDTO;
import com.pms.ocp.model.entity.OcpApiParam;
import com.pms.ocp.model.entity.OcpTenantIocn;
import com.pms.ocp.model.vo.ApiProvinceVo;
import com.pms.ocp.model.vo.OcpApiBaseVo;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.ApiDetailsService;
import com.pms.ocp.service.ApiProvinceService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class ApiProvinceServiceImpl implements ApiProvinceService {

    @Autowired
    private ApiProvinceMapper apiProvinceMapper;
    @Autowired
    private ApiParamMapper apiParamDao;
    @Autowired
    private AppRegisterMapper appRegisterMapper;

    @Override
    public boolean updateOrCreate(ApiProvinceVo apiProvinceVo) {
        String code = RandomStringUtils.getRandomString(32);
        apiProvinceVo.setApiCode(code);
        apiProvinceMapper.insert(apiProvinceVo);

        List<OcpTenantIocn> list = new ArrayList<>();
        OcpTenantIocn ocpTenantIocn = new OcpTenantIocn();
        ocpTenantIocn.setIocnType("api");
        ocpTenantIocn.setCodeNo(apiProvinceVo.getApiCode());
        ocpTenantIocn.setIocn(apiProvinceVo.getApiPic());
        list.add(ocpTenantIocn);
        int count = appRegisterMapper.batchInsert(list);
        List<OcpApiParam> apiParams = apiProvinceVo.getApiParams();
        if (CollectionUtils.isNotEmpty(apiParams)) {
            apiParams.forEach(apiParam -> {
                apiParamDao.insert(apiParam);
                apiParam.setApiCode(apiProvinceVo.getApiCode());
            });
        }
        return true;
    }
}
