package com.pms.ocp.service.impl;

import com.pms.ocp.mapper.AppArrangeMapper;
import com.pms.ocp.model.entity.OcpApiGroup;
import com.pms.ocp.model.entity.OcpTenantGroup;
import com.pms.ocp.service.AppArrangeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @className: AppArrangeServiceImpl
 * @Description:应用分类业务层
 * @atuthor: pei-chenxi
 * @DateTime: 2022/3/9 14:17
 */
@Service
@Slf4j
public class AppArrangeServiceImpl implements AppArrangeService {

    @Autowired
    private AppArrangeMapper appArrangeMapper;

    /**
    * @Description: 应用分类修改
    * @param ocpTenantGroup
    * @return falg
    **/
    @Override
    public boolean updateApp(OcpTenantGroup ocpTenantGroup) {
        boolean falg = true;
        List<OcpTenantGroup> ocpTenantGroups = appArrangeMapper.selectList(null);
        for (OcpTenantGroup tenantGroup : ocpTenantGroups) {
            String code = tenantGroup.getTenantGroupCode();
            if (code == ocpTenantGroup.getTenantGroupCode()) {
                falg = false;
                break;
            }
        }
        appArrangeMapper.updateById(ocpTenantGroup);
        return falg;
    }
}
