package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import com.pms.ocp.common.utils.RandomStringUtils;
import com.pms.ocp.mapper.OcpApiBaseMapper;
import com.pms.ocp.mapper.OcpApiTreeMapper;
import com.pms.ocp.model.QueryResponseResult;
import com.pms.ocp.model.dto.*;
import com.pms.ocp.model.entity.OcpApiGroup;

import com.pms.ocp.model.entity.OcpTenantGroup;
import com.pms.ocp.service.OcpApiTreeService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.javassist.runtime.Desc;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;


/**
 * @author zhaochengming
 */

@Service
@Slf4j
public class OcpApiTreeServiceImpl extends ServiceImpl<OcpApiTreeMapper, OcpApiGroup> implements OcpApiTreeService {


    @Autowired
    private OcpApiTreeMapper mapper;

    @Autowired
    private OcpApiBaseMapper ocpApiBaseMapper;



    /**
     * 服务树分类
     *
     * @return
     */

    @Override
    public List<OcpApiGroup> getByGroup(Long apiGroupPromotionType, String apiGroupCode) {

        if (!("".equals(apiGroupPromotionType)) && StringUtils.isBlank(apiGroupCode)) {
            List<OcpApiGroup> ocpApiGroups = mapper.selectTwoApiGroups(apiGroupPromotionType);
            List<OcpApiGroup> ocpApiGrouplist = new ArrayList<>();
            for (OcpApiGroup ocpApiGroup : ocpApiGroups) {
               if (StringUtils.isBlank(ocpApiGroup.getApiGroupPcode())){
                   ocpApiGrouplist.add(ocpApiGroup);
                }
            }
            return ocpApiGrouplist;
        } else if (!("".equals(apiGroupPromotionType)) && !(StringUtils.isBlank(apiGroupCode))) {
            List<OcpApiGroup> ocpApiGroups = mapper.selectThreeApiGroupsList(apiGroupPromotionType, apiGroupCode);
            return ocpApiGroups;
        }

        return null;
    }


    /**
     * 新增服务分类
     *
     * @param
     */
    @Override
    public OcpApiGroup insertTree(OcpApiGroup ocpApiGroup) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String code = RandomStringUtils.getRandomString(6);
        boolean flag = true;
//        List<OcpApiGroup> ocpApiGroups = mapper.selectList(null);
//        Stream<OcpApiGroup> ocpApiGroupStream = ocpApiGroups.stream().filter(item -> item.getApiGroupCode().equals(ocpApiGroup.getApiGroupPcode()));
//        Stream<OcpApiGroup> apiGroupStream1 = ocpApiGroupStream.filter(ocp -> ocp.getApiGroupName().equals(ocpApiGroup.getApiGroupName()));
        List<OcpApiGroup> ocpApiGroups1 = mapper.selectGroupName(ocpApiGroup.getApiGroupName());
        OcpApiGroup ocpApi = new OcpApiGroup();
        if (ocpApiGroups1.size() == 0) {

            ocpApi.setApiGroupPromotionType(ocpApiGroup.getApiGroupPromotionType());
            BeanUtils.copyProperties(ocpApiGroup, ocpApi);
            ocpApi.setObjId("");
            ocpApi.setApiGroupMtime(timestamp);
            ocpApi.setApiGroupCtime(timestamp);
            ocpApi.setApiGroupPcode(ocpApiGroup.getApiGroupCode());
            ocpApi.setApiGroupCode(code);
            ocpApi.setApiGroupPromotionType(ocpApiGroup.getApiGroupPromotionType());
            if ("Middleground".equals(ocpApiGroup.getApiGroupLevel())) {
                ocpApiGroup.setApiGroupLevel("sys_center");
            }
            if ("sys_center".equals(ocpApiGroup.getApiGroupLevel())) {
                ocpApiGroup.setApiGroupLevel("api_group");
            }
            if (StringUtils.isBlank(ocpApiGroup.getApiGroupLevel())) {
                ocpApiGroup.setApiGroupLevel("Middleground");
            }
            if (StringUtils.isNotBlank(ocpApiGroup.getClassIfy())) {
                ocpApi.setClassIfy(ocpApiGroup.getClassIfy());
            }
            ocpApi.setIsDelete(0);
            mapper.insert(ocpApi);
        } else {
            return ocpApi;
        }
        return ocpApi;

    }


    /**
     * 修改服务分类提交
     *
     * @param
     */
    @Override
    public boolean updataOcpTree(OcpApiGroup ocpApiGroup) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        boolean falg = true;
        List<OcpApiGroup> ocpApiGroups = mapper.selectList(null);
        for (OcpApiGroup apiGroup : ocpApiGroups) {
            String name = apiGroup.getApiGroupName();
            if (name.equals(ocpApiGroup.getApiGroupName())) {
                falg = false;
                break;
            }
        }
        if (falg) {
            ocpApiGroup.setApiGroupMtime(timestamp);
            mapper.updateById(ocpApiGroup);
        }
        return falg;
    }


    /**
     * 删除服务分类
     *
     * @param ocpApiGroup
     */
    @Override
    public boolean deleteOcpTree(OcpApiGroup ocpApiGroup) {
        boolean flag = true;
        LambdaQueryWrapper<OcpApiGroup> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(OcpApiGroup::getApiGroupPcode, ocpApiGroup.getApiGroupCode());
        String objId = ocpApiGroup.getObjId();

        List<OcpApiGroup> list = mapper.selectGroupPcode(ocpApiGroup.getApiGroupCode());
        if (list.size() >= 1) {
            flag = false;
        }
        if (flag) {
            mapper.deleteById(objId);
        }
        return flag;
    }


    /**
     * 服务列表分级查询
     *
     * @param pageGroupDto
     * @return
     */
    @Override
    public Page<OcpApiGroup> getOnePages(PageGroupDto pageGroupDto) {
        Page<OcpApiGroup> pageInfo = new Page(pageGroupDto.getCurrentPage(), pageGroupDto.getPageSize());
        LambdaQueryWrapper<OcpApiGroup> qw = new LambdaQueryWrapper<>();
        if (StringUtils.isBlank(pageGroupDto.getKeyword())) {
            if (StringUtils.isBlank(pageGroupDto.getApiGroupCode())) {
                qw.eq(OcpApiGroup::getApiGroupPromotionType, pageGroupDto.getApiGroupPromotionType()).orderByDesc(OcpApiGroup::getApiGroupMtime);

                mapper.selectPage(pageInfo, qw);

            } else if (!(StringUtils.isNotBlank(pageGroupDto.getApiGroupPcode()))) {
                List<OcpApiGroup> ocpApiGroups = mapper.selectLists(pageGroupDto.getApiGroupPromotionType(), pageGroupDto.getApiGroupCode());
                qw.eq(OcpApiGroup::getApiGroupPromotionType, pageGroupDto.getApiGroupPromotionType()).and(c -> c.eq(OcpApiGroup::getApiGroupPcode, pageGroupDto.getApiGroupCode())).orderByDesc(OcpApiGroup::getApiGroupMtime);
                pageInfo.setRecords(ocpApiGroups);
                mapper.selectPage(pageInfo, qw);
                List<OcpApiGroup> records = pageInfo.getRecords();
                for (OcpApiGroup record : records) {
                    OcpApiGroup ocpApiGroup = mapper.selectCode(record.getApiGroupPcode());
                    record.setClassIfy(ocpApiGroup.getApiGroupName());
                }


            }
        } else if (StringUtils.isNotBlank(pageGroupDto.getKeyword())) {
            if (StringUtils.isBlank(pageGroupDto.getApiGroupCode())){
                LambdaQueryWrapper<OcpApiGroup> ocpTenantGroupLambdaQueryWrapper = qw.and(c -> c.like(OcpApiGroup::getApiGroupName, pageGroupDto.getKeyword()))
                        .and(c->c.eq(OcpApiGroup::getApiGroupPromotionType,pageGroupDto.getApiGroupPromotionType())).orderByDesc(OcpApiGroup::getApiGroupMtime);
                mapper.selectPage(pageInfo, ocpTenantGroupLambdaQueryWrapper);

            }else if (StringUtils.isNotBlank(pageGroupDto.getApiGroupCode())) {
                LambdaQueryWrapper<OcpApiGroup> ocpTenantGroupLambdaQueryWrapper = qw.and(c -> c.like(OcpApiGroup::getApiGroupName, pageGroupDto.getKeyword()))
                        .and(c -> c.eq(OcpApiGroup::getApiGroupPcode, pageGroupDto.getApiGroupCode())).orderByDesc(OcpApiGroup::getApiGroupMtime);
                mapper.selectPage(pageInfo, ocpTenantGroupLambdaQueryWrapper);
            }
        }


        return pageInfo;
    }
}


