package com.pms.ocp.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.pms.ocp.common.constants.CodeEnum;
import com.pms.ocp.common.utils.GUIDGenerator;
import com.pms.ocp.common.utils.RandomStringUtils;
import com.pms.ocp.mapper.*;
import com.pms.ocp.model.CommonCode;
import com.pms.ocp.model.ResponseResult;
import com.pms.ocp.model.entity.*;
import com.pms.ocp.model.vo.OcpApiGroupVo;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.PmsApiManagementService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;


@Service
public class PmsApiManagementServiceImpl extends ServiceImpl<PmsApiManagementMapper, PmsApiManagement> implements PmsApiManagementService {

    @Autowired
    private PmsApiManagementMapper pmsApiManagementMapper;

    @Autowired
    private OcpApiBaseMapper ocpApiBaseMapper;

    @Autowired
    private OcpApiGroupMapper ocpApiGroupMapper;

    @Autowired
    private PmsApiModelRelMapper pmsApiModelRelMapper;

    @Autowired
    private OcpApiGroupVoMapper ocpApiGroupVoMapper;



    @Override
    public ResponseVO<PageInfo<PmsApiManagement>> getPammList(PmsApiManagement pmsApiManagement) {
        if (pmsApiManagement.getPageNum() ==null || pmsApiManagement.getPageSize() == null) {
            return ResponseVO.error("分页参数不能为空");
        }
        PageHelper.startPage(pmsApiManagement.getPageNum(),pmsApiManagement.getPageSize());
        List<PmsApiManagement> pammList = pmsApiManagementMapper.getList(pmsApiManagement);
        PageInfo<PmsApiManagement> pageInfo = new PageInfo<>(pammList);
        return ResponseVO.ok(pageInfo);
    }

    @Override
    public ResponseVO getPammByCode(PmsApiManagement pmsApiManagement) {
        List<PmsApiManagement> pammByCode = pmsApiManagementMapper.getPammByCode(pmsApiManagement);
        return ResponseVO.ok(pammByCode);
    }



    @Override
    public PmsApiMangageApi add(PmsApiMangageApi pmsApiMangageApi) {
        String randomString = RandomStringUtils.getRandomString(32);
        pmsApiMangageApi.setObjId(randomString);
//        pmsApiMangageApi.setApiCtime(pmsApiMangageApi.getApiMtime());
        pmsApiManagementMapper.addPamm(pmsApiMangageApi);
        return pmsApiMangageApi;
    }

    @Override
    public ResponseResult deleteApi(PmsApiMangageApi pmsApiMangageApi) {
        //服务模型
        int apiModelCount = pmsApiManagementMapper.getApiModel(pmsApiMangageApi.getApiCode());
        //应用服务
        int apiTenantCount  = pmsApiManagementMapper.getApitenant(pmsApiMangageApi.getApiCode());
        if(apiModelCount==0 && apiTenantCount==0){
            pmsApiManagementMapper.deleteApi(pmsApiMangageApi);
            return ResponseResult.SUCCESS(true);
        }
       return ResponseResult.SUCCESS(false);

        }

    @Override
    public PmsApiMangageApi updateApi(PmsApiMangageApi pmsApiMangageApi) {
        int i = pmsApiManagementMapper.updatePamm(pmsApiMangageApi);
        //pmsApiManagementMapper.updateExent(pmsApiMangageApi);
        //pmsApiManagementMapper.uodateIcon(pmsApiMangageApi);
        if(i==0){
            pmsApiMangageApi.setBoole(false);
        }else {
            pmsApiMangageApi.setBoole(true);
        }
        return pmsApiMangageApi;
    }

    @Override
    public ResponseVO<List<OcpApiGroupVo>> getApiNavigation() {
        //根据是否传入搜索条件创建构造器进行查询
        List<OcpApiGroupVo> apiTypeList = this.selectByCondition(null, null);
        if (CollectionUtil.isEmpty(apiTypeList)) {
            return ResponseVO.error(CodeEnum.NO_DATA);
        }
        //对模型分类信息进行处理
        List<OcpApiGroupVo> resultList = this.build(apiTypeList);
        return ResponseVO.ok(resultList);
    }


    private List<OcpApiGroupVo> selectByCondition(String... searchCondition) {
        QueryWrapper<OcpApiGroupVo> queryWrapper = new QueryWrapper<>();
        //根据是否传入搜索条件创建构造器进行查询
        queryWrapper.eq(StringUtils.isNotEmpty(searchCondition[0]), "api_group_pcode", searchCondition[0])
                .like(StringUtils.isNotEmpty(searchCondition[1]),"api_group_name", searchCondition[1]);
        return ocpApiGroupVoMapper.selectList(queryWrapper);
    }

    private List<OcpApiGroupVo> build(List<OcpApiGroupVo> treeNodes) {
        List<OcpApiGroupVo> result = new ArrayList<>();
        //list转map =>将每个对象的id作为key,自己作为value.
        Map<String, OcpApiGroupVo> nodeMap = new LinkedHashMap<>(treeNodes.size());
        for (OcpApiGroupVo treeNode : treeNodes) {
            nodeMap.put(treeNode.getApiGroupCode(), treeNode);
        }
        for (OcpApiGroupVo node : nodeMap.values()) {
            //得到自己的父类
            OcpApiGroupVo parent = nodeMap.get(node.getApiGroupPcode());
            if (parent != null && (node.getApiGroupPcode().equals(parent.getApiGroupCode()))
                    && (!"".equals(node.getApiGroupPcode())|| !"".equals(parent.getApiGroupCode()))
                    && !parent.getApiGroupCode().equals(node.getApiGroupCode())) {
                //防止每次都new list或者只是使用该对象就new对象浪费内存或者覆盖上一次记录
                if (parent.getChildrenList() == null) {
                    parent.setChildrenList(new LinkedList<>());
                }
                //设置上级父类名称
                node.setClassIfy(parent.getApiGroupName());
                //说明他有父类其下子类都需要加一级
                parent.getChildrenList().add(node);
                continue;
            }
            result.add(node);
        }
        return result;
    }


    private QueryWrapper<OcpApiBase> getCondition(String apiCode){
        QueryWrapper<OcpApiBase> qw = new QueryWrapper<>();

        if(StringUtils.isNotBlank(apiCode)){
            qw.eq("api_code",apiCode);
        }
        return qw;
    }

}
