package com.pms.ocp.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.common.constants.AnalysisConstant;
import com.pms.ocp.common.constants.ExportUtils;
import com.pms.ocp.mapper.OcpApiTenantRelMapper;
import com.pms.ocp.mapper.OcpTenantAuditMapper;
import com.pms.ocp.mapper.PmsApiTenantRelMapper;
import com.pms.ocp.mapper.PmsTenantAuditMapper;
import com.pms.ocp.model.entity.OcpApiTenantRel;
import com.pms.ocp.model.entity.OcpTenantAudit;
import com.pms.ocp.model.entity.PmsTenantAudit;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.OcpTenantAuditService;
import com.pms.ocp.service.PmsTenantAuditService;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Service
public class PmsTenantAuditServiceImpl extends ServiceImpl<PmsTenantAuditMapper, PmsTenantAudit> implements PmsTenantAuditService {
    @Autowired
    private PmsTenantAuditMapper pmsTenantAuditMapper;

    @Autowired
    private PmsApiTenantRelMapper pmsApiTenantRelMapper;

    @Override
    public ResponseVO getOtaList(PmsTenantAudit pmsTenantAudit) {
        List<PmsTenantAudit> otaList = pmsTenantAuditMapper.getOtaList(pmsTenantAudit);
        return ResponseVO.ok(otaList);
    }

    @Override
    public ResponseVO getOtaListById(PmsTenantAudit pmsTenantAudit) {
        List<PmsTenantAudit> otaListById = pmsTenantAuditMapper.getOtaListById(pmsTenantAudit);
        return ResponseVO.ok(otaListById);
    }

    @Override
    public void exportExcel(PmsTenantAudit pmsTenantAudit, HttpServletRequest request, HttpServletResponse response) {
        List<PmsTenantAudit> otaListById = pmsTenantAuditMapper.versionId(pmsTenantAudit);
        ExportParams param = new ExportParams(AnalysisConstant.exportOcpTenantApiName.OCPTENANTNAME,AnalysisConstant.exportOcpTenantApiName.OCPTENANTNAME);
        Workbook workbook = ExcelExportUtil.exportExcel(param, PmsTenantAudit.class,otaListById);
        ExportUtils.exportExcel(response, AnalysisConstant.exportOcpTenantApiName.OCPTENANT,workbook);
    }

    @Override
    public ResponseVO OtaById(PmsTenantAudit pmsTenantAudit) {
        List<PmsTenantAudit> oatrList = pmsTenantAuditMapper.OtaById(pmsTenantAudit);
        return ResponseVO.ok(oatrList);
    }

    @Override
    public ResponseVO versionId(PmsTenantAudit pmsTenantAudit) {
        List<PmsTenantAudit> ocpTenantAudits = pmsTenantAuditMapper.versionId(pmsTenantAudit);
        return ResponseVO.ok(ocpTenantAudits);
    }


}
