package com.pms.ocp.common.exception;

import com.pms.ocp.common.constants.ResultCode;

/**
 * @Auther: wangjian
 * @Date: 2022/3/11 16:31
 * @Description:
 */
public class ServiceException extends RuntimeException {

    /**
     * 自定义异常枚举类
     */
    private ResultCode resultCode;

    /**
     * 错误码
     */
    private int code;

    /**
     * 错误信息
     */
    private String errorMsg;


    public ServiceException() {
        super();
    }

    public ServiceException(ResultCode resultCode) {
        super("{code:" + resultCode.getStatusCode() + ",errorMsg:" + resultCode.getMessage() + "}");
        this.resultCode = resultCode;
        this.code = resultCode.getStatusCode();
        this.errorMsg = resultCode.getMessage();
    }

    public ServiceException(int code, String errorMsg) {
        super("{code:" + code + ",errorMsg:" + errorMsg + "}");
        this.code = code;
        this.errorMsg = errorMsg;
    }

    public ResultCode getErrorEnum() {
        return resultCode;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }
}
