package com.pms.ocp.common.handler;

import org.apache.ibatis.type.LocalDateTimeTypeHandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

/**
 * @Auther: wangjian
 * @Date: 2022/3/10 10:10
 * @Description:时间类型处理器
 */
public class MYLocalDateTimeTypeHandler extends LocalDateTimeTypeHandler {
//    @Override
//    public LocalDateTime getNullableResult(ResultSet rs, String columnName) throws SQLException {
//        Timestamp timestamp = rs.getTimestamp(columnName);
//        Long remindTime = timestamp.getTime();
//        return LocalDateTime.ofEpochSecond(remindTime,0, ZoneOffset.ofHours(8));
//    }


//    @Override
//    public LocalDateTime getResult(ResultSet rs, String columnName) throws SQLException {
//        Object object = rs.getObject(columnName);
//        System.out.println(object);
//        if (object instanceof java.sql.Timestamp) {//在这里强行转换，将sql的时间转换为LocalDateTime
//            //可以根据自己的需要进行转化
//            return LocalDateTime.ofInstant(((Timestamp) object).toInstant(), ZoneOffset.ofHours(0));
//        }
//        return super.getResult(rs, columnName);
//    }

    @Override
    public LocalDateTime getResult(ResultSet rs, String columnName) throws SQLException {
        Object object = rs.getObject(columnName);
        if (object == null) {
            return null;
        }

//        System.out.println(object);
        // 如有需要 在这里强行转换，将sql的时间转换为LocalDateTime
        if (object instanceof java.sql.Timestamp) {
            //可以根据自己的需要进行转化
            return LocalDateTime.ofInstant(((Timestamp) object).toInstant(), ZoneOffset.ofHours(8));
        }

        return super.getResult(rs, columnName);
    }


}
