package com.pms.ocp.controller;


import com.pms.ocp.model.entity.*;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;


@Slf4j
@RequestMapping("/api")
@RestController
@Api(tags = "服务接口")
public class OcpApiDetailsController {

    @Autowired
    private OcpApiSubsService ocpApiSubsService;

    @Autowired
    private OcpApiAuditService ocpApiAuditService;

    @Autowired
    private OcpApiTenantRelService ocpApiTenantRelService;

    @Autowired
    private OcpApiModelRelService ocpApiModelRelService;


    @ApiOperation("服务订阅记录-查询")
    @PostMapping("/getocpapisublist")
    public ResponseVO<List<OcpApiSubs>> getOcpApiSubsList(OcpApiSubs ocpApiSubs) {
        return ocpApiSubsService.getOcpApiSubsList(ocpApiSubs);
    }

    @ApiOperation("服务大事记-查询")
    @PostMapping("/getocpapiauditlist")
    public ResponseVO<List<OcpApiAudit>> getOcpApiAuditList(OcpApiAudit ocpApiAudit) {
        return ocpApiAuditService.getOcpApiAuditList(ocpApiAudit);
    }

//    @ApiOperation("服务大事记-查询详情")
//    @PostMapping("/getocpapidetails")
//    public ResponseVO<List<OcpApiAudit>> getOcpApiDetails(@RequestBody OcpApiAudit ocpApiAudit){
//        return ocpApiAuditService.sById(ocpApiAudit);
//    }

    @ApiOperation("服务大事记-查询详情-变更内容")
    @PostMapping("/getocpapi")
    public ResponseVO<List<OcpApiAudit>> getOcpApi(@RequestBody OcpApiAudit ocpApiAudit){
        return ocpApiAuditService.OaaById(ocpApiAudit);
    }

    @ApiOperation("服务大事记-历史版本")
    @PostMapping("/versionid")
    public ResponseVO<List<OcpApiAudit>> versionId(@RequestBody OcpApiAudit ocpApiAudit){
        return ocpApiAuditService.versionId(ocpApiAudit);
    }

    @ApiOperation("服务与应用拓扑图-查询")
    @PostMapping("/getoatrlist")
    public ResponseVO<List<OcpApiTenantRel>> getOatrList(@RequestBody OcpApiTenantRel ocpApiTenantRel) {
        return ocpApiTenantRelService.getOatrList(ocpApiTenantRel);
    }

    @ApiOperation("服务与模型拓扑图-查询")
    @PostMapping("/getoamrlist")
    public ResponseVO<List<OcpApiModelRel>> getOamrList(@RequestBody OcpApiModelRel ocpApiModelRel) {
        return ocpApiModelRelService.getOamrList(ocpApiModelRel);
    }

    @ApiOperation("服务大事记-导出")
    @RequestMapping("/export")
    public void exportExcel(@RequestBody(required = false) OcpApiAudit ocpApiAudit, HttpServletRequest request, HttpServletResponse response) {
        ocpApiAuditService.exportExcel(ocpApiAudit,request,response);
    }



}
